/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.freemarker.LifecycleRenderingContext;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleProcessorBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.view.DefaultExpressionEvaluator;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.ExpressionEvaluatorFactory;
import org.springframework.util.StringUtils;

public class SynchronousViewLifecycleProcessor
extends ViewLifecycleProcessorBase {
    private static final Logger LOG = LogManager.getLogger(SynchronousViewLifecycleProcessor.class);
    private final Deque<ViewLifecyclePhase> pendingPhases = new LinkedList<ViewLifecyclePhase>();
    private ViewLifecyclePhase activePhase;
    private LifecycleRenderingContext renderingContext;
    private final ExpressionEvaluator expressionEvaluator;
    private final Map<String, TraceNode> trace;

    private static String getTracePath(ViewLifecyclePhase phase) {
        Component parent = phase.getParent();
        if (parent == null) {
            return "";
        }
        return phase.getParent().getViewPath();
    }

    private TraceNode getTraceNode(ViewLifecyclePhase phase) {
        if (this.trace == null) {
            return null;
        }
        String tracePath = SynchronousViewLifecycleProcessor.getTracePath(phase);
        TraceNode traceNode = this.trace.get(tracePath);
        if (traceNode == null) {
            traceNode = new TraceNode(phase);
            this.trace.put(tracePath, traceNode);
        }
        return traceNode;
    }

    public SynchronousViewLifecycleProcessor(ViewLifecycle lifecycle) {
        super(lifecycle);
        ExpressionEvaluatorFactory expressionEvaluatorFactory;
        HashMap hashMap = this.trace = ViewLifecycle.isTrace() ? new HashMap() : null;
        if (lifecycle.helper == null) {
            LOG.warn("No helper is defined for the view lifecycle, using global expression evaluation factory");
            expressionEvaluatorFactory = KRADServiceLocatorWeb.getExpressionEvaluatorFactory();
        } else {
            expressionEvaluatorFactory = lifecycle.helper.getExpressionEvaluatorFactory();
        }
        if (expressionEvaluatorFactory == null) {
            LOG.warn("No global expression evaluation factory is defined, using DefaultExpressionEvaluator");
            this.expressionEvaluator = new DefaultExpressionEvaluator();
        } else {
            this.expressionEvaluator = expressionEvaluatorFactory.createExpressionEvaluator();
        }
    }

    @Override
    public void offerPendingPhase(ViewLifecyclePhase pendingPhase) {
        this.pendingPhases.offer(pendingPhase);
    }

    @Override
    public void pushPendingPhase(ViewLifecyclePhase phase) {
        this.pendingPhases.push(phase);
    }

    @Override
    public void performPhase(ViewLifecyclePhase initialPhase) {
        long startTime = System.currentTimeMillis();
        TraceNode initialNode = this.getTraceNode(initialPhase);
        this.offerPendingPhase(initialPhase);
        while (!this.pendingPhases.isEmpty()) {
            ViewLifecyclePhase pendingPhase = this.pendingPhases.poll();
            long phaseStartTime = System.currentTimeMillis();
            try {
                if (this.trace != null) {
                    this.getTraceNode(pendingPhase).startTrace(pendingPhase);
                }
                pendingPhase.run();
                if (this.trace == null) continue;
                this.getTraceNode(pendingPhase).finishTrace(phaseStartTime, null);
            }
            catch (Throwable e) {
                if (this.trace != null) {
                    this.getTraceNode(pendingPhase).finishTrace(phaseStartTime, e);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new IllegalStateException(e);
            }
        }
        if (this.trace != null) {
            assert (initialNode != null) : initialPhase;
            LinkedList<TraceNode> msgQueue = new LinkedList<TraceNode>();
            StringBuilder msg = new StringBuilder();
            msgQueue.push(initialNode);
            while (!msgQueue.isEmpty()) {
                TraceNode traceNode = (TraceNode)msgQueue.pop();
                assert (traceNode != null) : String.valueOf(msg) + " " + String.valueOf(this.trace.keySet());
                assert (traceNode.buffer != null) : traceNode.path;
                msg.append((CharSequence)traceNode.buffer);
                for (String childPath : traceNode.childPaths) {
                    TraceNode child = this.trace.get(traceNode.path + (traceNode.path.equals("") ? "" : ".") + childPath);
                    if (child == null) continue;
                    msgQueue.push(child);
                }
            }
            LOG.info("Lifecycle phase processing completed in " + ProcessLogger.intervalToString(System.currentTimeMillis() - startTime) + String.valueOf(msg));
            this.trace.clear();
        }
    }

    @Override
    public ViewLifecyclePhase getActivePhase() {
        return this.activePhase;
    }

    @Override
    public LifecycleRenderingContext getRenderingContext() {
        if (this.renderingContext == null && ViewLifecycle.isRenderInLifecycle()) {
            ViewLifecycle lifecycle = this.getLifecycle();
            this.renderingContext = new LifecycleRenderingContext(lifecycle.model, lifecycle.request);
        }
        return this.renderingContext;
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator() {
        return this.expressionEvaluator;
    }

    @Override
    void setActivePhase(ViewLifecyclePhase phase) {
        if (this.activePhase != null && phase != null) {
            throw new IllegalStateException("Another phase is already active on this lifecycle thread " + String.valueOf(this.activePhase));
        }
        this.activePhase = phase;
    }

    private static final class TraceNode {
        private final String path;
        private StringBuilder buffer = new StringBuilder();
        private Set<String> childPaths = new LinkedHashSet<String>();

        private TraceNode(ViewLifecyclePhase phase) {
            this.path = SynchronousViewLifecycleProcessor.getTracePath(phase);
        }

        private void startTrace(ViewLifecyclePhase phase) {
            try {
                LifecycleElement element = phase.getElement();
                String parentPath = phase.getParentPath();
                if (StringUtils.hasLength((String)parentPath)) {
                    this.childPaths.add(phase.getParentPath());
                }
                this.buffer.append('\n');
                for (int i = 0; i < phase.getDepth(); ++i) {
                    this.buffer.append("  ");
                }
                this.buffer.append(phase.getViewPath());
                this.buffer.append(' ');
                this.buffer.append(phase.getEndViewStatus());
                this.buffer.append(' ');
                this.buffer.append(element.getViewStatus());
                this.buffer.append(' ');
                this.buffer.append(element.isRender());
                this.buffer.append(' ');
                this.buffer.append(element.getClass().getSimpleName());
                this.buffer.append(' ');
                this.buffer.append(element.getId());
                this.buffer.append(' ');
            }
            catch (Throwable e) {
                LOG.warn("Error tracing lifecycle", e);
            }
        }

        private void finishTrace(long phaseStartTime, Throwable error) {
            if (error == null) {
                this.buffer.append(" done ");
            } else {
                this.buffer.append(" ERROR ");
            }
            this.buffer.append(ProcessLogger.intervalToString(System.currentTimeMillis() - phaseStartTime));
        }
    }
}

