/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.lifecycle.LifecycleRefreshPathBuilder;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecyclePhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleProcessor;
import org.kuali.rice.krad.uif.service.ViewHelperService;
import org.kuali.rice.krad.uif.util.ProcessLogger;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.UifFormBase;

public class ViewLifecycleBuild
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(ViewLifecycleBuild.class);
    private final Map<String, String> parameters;
    private final Map<String, List<String>> refreshPathMappings;

    public ViewLifecycleBuild(Map<String, String> parameters, Map<String, List<String>> refreshPathMappings) {
        this.parameters = parameters;
        this.refreshPathMappings = refreshPathMappings;
    }

    @Override
    public void run() {
        View view = ViewLifecycle.getView();
        ProcessLogger.trace("begin-view-lifecycle:" + view.getId());
        this.populateViewRequestParameters();
        this.runInitializePhase();
        this.runApplyModelPhase();
        this.runFinalizePhase();
        ((ViewModel)ViewLifecycle.getModel()).setApplyDefaultValues(false);
        String growlScript = ViewLifecycle.getHelper().buildGrowlScript();
        ((ViewModel)ViewLifecycle.getModel()).setGrowlScript(growlScript);
        if (ViewLifecycle.isRefreshLifecycle()) {
            PageGroup page = view.getCurrentPage();
            page.getValidationMessages().generateMessages(view, ViewLifecycle.getModel(), page);
        }
        LifecycleRefreshPathBuilder.processLifecycleElements();
        ViewLifecycle.getViewPostMetadata().cleanAfterLifecycle();
        ProcessLogger.trace("finalize:" + view.getId());
    }

    protected void populateViewRequestParameters() {
        View view = ViewLifecycle.getView();
        ViewHelperService helper = ViewLifecycle.getHelper();
        UifFormBase model = (UifFormBase)ViewLifecycle.getModel();
        Map<String, String> parametersToPopulate = this.parameters;
        if (ViewLifecycle.isRefreshLifecycle()) {
            parametersToPopulate = model.getViewRequestParameters();
        }
        helper.populateViewFromRequestParameters(parametersToPopulate);
        model.setViewRequestParameters(view.getViewRequestParameters());
    }

    protected void runInitializePhase() {
        ViewLifecycleProcessor processor = ViewLifecycle.getProcessor();
        List<String> refreshPaths = null;
        if (this.refreshPathMappings != null) {
            refreshPaths = this.refreshPathMappings.get("INITIALIZE");
        }
        ViewLifecyclePhase phase = KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase(ViewLifecycle.getView(), "INITIALIZE", refreshPaths);
        View view = ViewLifecycle.getView();
        ViewHelperService helper = ViewLifecycle.getHelper();
        UifFormBase model = (UifFormBase)ViewLifecycle.getModel();
        ViewLifecycle.getExpressionEvaluator().initializeEvaluationContext(model);
        if (LOG.isInfoEnabled()) {
            LOG.info("performing initialize phase for view: " + view.getId());
        }
        helper.performCustomViewInitialization(model);
        processor.performPhase(phase);
        ProcessLogger.trace("initialize:" + view.getId());
    }

    protected void runApplyModelPhase() {
        ViewLifecycleProcessor processor = ViewLifecycle.getProcessor();
        List<String> refreshPaths = null;
        if (this.refreshPathMappings != null) {
            refreshPaths = this.refreshPathMappings.get("APPLY_MODEL");
        }
        ViewLifecyclePhase phase = KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase(ViewLifecycle.getView(), "APPLY_MODEL", refreshPaths);
        View view = ViewLifecycle.getView();
        ViewHelperService helper = ViewLifecycle.getHelper();
        UifFormBase model = (UifFormBase)ViewLifecycle.getModel();
        if (LOG.isInfoEnabled()) {
            LOG.info("performing apply model phase for view: " + view.getId());
        }
        if (model.isApplyDefaultValues()) {
            helper.applyDefaultValues(view);
            model.setApplyDefaultValues(false);
        }
        if (model.isEvaluateFlagsAndModes()) {
            helper.retrieveEditModesAndActionFlags();
            model.setActionFlags(view.getActionFlags());
            model.setEditModes(view.getEditModes());
            model.setEvaluateFlagsAndModes(false);
        } else {
            view.setActionFlags(model.getActionFlags());
            view.setEditModes(model.getEditModes());
        }
        helper.setViewContext();
        processor.performPhase(phase);
        ProcessLogger.trace("apply-model:" + view.getId());
    }

    protected void runFinalizePhase() {
        ViewLifecycleProcessor processor = ViewLifecycle.getProcessor();
        List<String> refreshPaths = null;
        if (this.refreshPathMappings != null) {
            refreshPaths = this.refreshPathMappings.get("FINALIZE");
        }
        ViewLifecyclePhase phase = KRADServiceLocatorWeb.getViewLifecyclePhaseBuilder().buildPhase(ViewLifecycle.getView(), "FINALIZE", refreshPaths);
        View view = ViewLifecycle.getView();
        if (LOG.isInfoEnabled()) {
            LOG.info("performing finalize phase for view: " + view.getId());
        }
        processor.performPhase(phase);
    }
}

