/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle.finalize;

import java.util.Map;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.krad.uif.lifecycle.FinalizeComponentPhase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.util.ScriptUtils;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;

public class FinalizeViewTask
extends ViewLifecycleTaskBase<View> {
    public FinalizeViewTask() {
        super(View.class);
    }

    @Override
    public FinalizeComponentPhase getElementState() {
        return (FinalizeComponentPhase)super.getElementState();
    }

    @Override
    protected void performLifecycleTask() {
        View view = (View)this.getElementState().getElement();
        assert (view == ViewLifecycle.getView());
        Object model = ViewLifecycle.getModel();
        view.setPreLoadScript(ScriptUtils.appendScript(view.getPreLoadScript(), this.buildClientSideStateScript(model)));
    }

    protected String buildClientSideStateScript(Object model) {
        Map<String, Object> clientSideState = ((ViewModel)model).getClientStateForSyncing();
        Object clientStateScript = "";
        if (!clientSideState.isEmpty()) {
            clientStateScript = ScriptUtils.buildFunctionCall("initializeViewState", clientSideState);
        }
        String kradImageLocation = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.externalizable.images.url");
        clientStateScript = (String)clientStateScript + ScriptUtils.buildFunctionCall("setConfigParam", "kradImageLocation", kradImageLocation);
        String kradURL = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("krad.url");
        clientStateScript = (String)clientStateScript + ScriptUtils.buildFunctionCall("setConfigParam", "kradUrl", kradURL);
        String applicationURL = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("application.url");
        clientStateScript = (String)clientStateScript + ScriptUtils.buildFunctionCall("setConfigParam", "applicationUrl", applicationURL);
        String scriptCleanup = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("rice.krad.script.cleanup");
        clientStateScript = (String)clientStateScript + ScriptUtils.buildFunctionCall("setConfigParam", "scriptCleanup", scriptCleanup);
        return clientStateScript;
    }
}

