/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.view;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.DocumentView;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.form.TransactionalDocumentFormBase;

@BeanTag(name="transactionalDocumentView", parent="Uif-TransactionalDocumentView")
public class TransactionalDocumentView
extends DocumentView {
    private static final long serialVersionUID = 4375336878804984171L;
    private PessimisticLockService pessimisticLockService;

    public TransactionalDocumentView() {
        this.setViewTypeName(UifConstants.ViewType.TRANSACTIONAL);
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.getDocumentEntryForView().getUsePessimisticLocking()) {
            TransactionalDocumentFormBase form = (TransactionalDocumentFormBase)model;
            this.generatePessimisticLockMessages(form);
            this.setupPessimisticLockingTimeout(form);
        }
    }

    protected void generatePessimisticLockMessages(TransactionalDocumentFormBase form) {
        Document document = form.getDocument();
        Person user = GlobalVariables.getUserSession().getPerson();
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(user)) continue;
            String lockDescriptor = StringUtils.defaultIfBlank((String)lock.getLockDescriptor(), (String)"full");
            String lockOwner = lock.getOwnedByUser().getName();
            String lockTime = RiceConstants.getDefaultTimeFormat().format(lock.getGeneratedTimestamp());
            String lockDate = RiceConstants.getDefaultDateFormat().format(lock.getGeneratedTimestamp());
            GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.transactional.locked", new String[]{lockDescriptor, lockOwner, lockTime, lockDate});
        }
    }

    protected void setupPessimisticLockingTimeout(TransactionalDocumentFormBase form) {
        Document document = form.getDocument();
        if (!document.getPessimisticLocks().isEmpty()) {
            form.getView().getSessionPolicy().setEnableTimeoutWarning(true);
        }
    }

    protected PessimisticLockService getPessimisticLockService() {
        if (this.pessimisticLockService == null) {
            this.pessimisticLockService = KRADServiceLocatorWeb.getPessimisticLockService();
        }
        return this.pessimisticLockService;
    }

    protected void setPessimisticLockService(PessimisticLockService pessimisticLockService) {
        this.pessimisticLockService = pessimisticLockService;
    }
}

