/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krms.api.engine.Engine;
import org.kuali.rice.krms.api.engine.expression.ComparisonOperatorService;
import org.kuali.rice.krms.api.repository.RuleRepositoryService;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;

import javax.xml.namespace.QName;

/**
 * A static service locator which aids in locating the various remotable services that form the Kuali Rule Management System API.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class KrmsApiServiceLocator {

	public static final String ENGINE = "rice.krms.engine";
	public static final QName RULE_REPOSITORY_SERVICE = new QName(KrmsConstants.Namespaces.KRMS_NAMESPACE_2_0, "ruleRepositoryService");
    public static final QName KRMS_TYPE_REPOSITORY_SERVICE = new QName(KrmsConstants.Namespaces.KRMS_NAMESPACE_2_0, "krmsTypeRepositoryService");
    public static final String COMPARISON_SERVICE = "comparisonOperatorService";

    static <T> T getService(String serviceName) {
        return GlobalResourceLoader.<T>getService(QName.valueOf(serviceName));
    }

    static <T> T getService(QName serviceName) {
        return GlobalResourceLoader.<T>getService(serviceName);
    }

    public static Engine getEngine() {
        return getService(ENGINE);
    }

    public static RuleRepositoryService getRuleRepositoryService() {
    	return getService(RULE_REPOSITORY_SERVICE);
    }

    public static KrmsTypeRepositoryService getKrmsTypeRepositoryService() {
        return getService(KRMS_TYPE_REPOSITORY_SERVICE);
    }

    public static ComparisonOperatorService getComparisonOperatorService() {
        return getService(COMPARISON_SERVICE);
    }
}
