/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.type;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="KrmsAttributeDefinition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KrmsAttributionDefinitionType", propOrder={"id", "name", "namespace", "label", "description", "active", "componentName", "versionNumber", "_futureElements"})
public final class KrmsAttributeDefinition
extends AbstractDataTransferObject
implements KrmsAttributeDefinitionContract {
    private static final long serialVersionUID = -6356968810972165031L;
    @XmlElement(name="id", required=true)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="namespace", required=true)
    private final String namespace;
    @XmlElement(name="label", required=false)
    private final String label;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="componentName", required=false)
    private final String componentName;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KrmsAttributeDefinition() {
        this.id = null;
        this.name = null;
        this.namespace = null;
        this.label = null;
        this.description = null;
        this.active = true;
        this.componentName = null;
        this.versionNumber = null;
    }

    private KrmsAttributeDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.namespace = builder.getNamespace();
        this.label = builder.getLabel();
        this.description = builder.getDescription();
        this.active = builder.isActive();
        this.componentName = builder.getComponentName();
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Builder
    implements KrmsAttributeDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -2110564370088779631L;
        private String id;
        private String name;
        private String namespace;
        private String label;
        private String description;
        private boolean active;
        private String componentName;
        private Long versionNumber;

        private Builder(String id, String name, String namespace) {
            this.setId(id);
            this.setName(name);
            this.setNamespace(namespace);
            this.setActive(true);
        }

        public Builder label(String label) {
            this.setLabel(label);
            return this;
        }

        public Builder componentName(String componentName) {
            this.setComponentName(componentName);
            return this;
        }

        public static Builder create(String id, String name, String namespace) {
            return new Builder(id, name, namespace);
        }

        public static Builder create(KrmsAttributeDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getId(), contract.getName(), contract.getNamespace());
            builder.setActive(contract.isActive());
            builder.setLabel(contract.getLabel());
            builder.setDescription(contract.getDescription());
            builder.setComponentName(contract.getComponentName());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public void setId(String id) {
            if (null != id && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("id must be null or non-blank");
            }
            this.id = id;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException("namespace is blank");
            }
            this.namespace = namespace;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getComponentName() {
            return this.componentName;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public boolean isActive() {
            return this.active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public KrmsAttributeDefinition build() {
            return new KrmsAttributeDefinition(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/KrmsAttributionDefinitionType";
    }

    public static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String NAMESPACE = "namespace";
        static final String LABEL = "label";
        static final String DESCRIPTION = "description";
        static final String COMPONENT_NAME = "componentName";
        static final String ACTIVE = "active";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "KrmsAttributeDefinition";
        static final String TYPE_NAME = "KrmsAttributionDefinitionType";

        Constants() {
        }
    }
}

