/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository.language;

import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

import java.util.Map;

/**
 * Defines the contract for a {@link NaturalLanguageTemplate}
 *
 * @see NaturalLanguageTemplate
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface NaturalLanguageTemplateContract extends Identifiable, Inactivatable, Versioned {
    /**
     * This is the Language Code of the NaturalLanguageTemplate
     * <p>
     * The Language Code of the NaturalLanguageTemplate
     * </p>
     * @return the Language Code of the NaturalLanguageTemplate
     */
    String getLanguageCode();

    /**
     * This is the NaturalLanguageUsageId of the NaturalLanguageTemplate
     * <p>
     * The NaturalLanguageUsageId of the NaturalLanguageTemplate
     * </p>
     * @return the NaturalLanguageUsageId of the NaturalLanguageTemplate
     */
    String getNaturalLanguageUsageId();

    /**
     * This is the TypeId of the NaturalLanguageTemplate
     * <p>
     * The TypeId of the NaturalLanguageTemplate
     * </p>
     * @return the TypeId of the NaturalLanguageTemplate
     */
    String getTypeId();

    /**
     * This is the Template of the NaturalLanguageTemplate
     * <p>
     * The Template of the NaturalLanguageTemplate
     * </p>
     * @return the Template of the NaturalLanguageTemplate
     */
    String getTemplate();

    /**
     * This method returns a list of custom/remote attributes associated with the
     * agenda.
     * <p>
     * The attributes of the NaturalLanguageUsage
     * </p>
     * @return a list of custom/remote attribute of the agenda.
     */
    public Map<String, String> getAttributes();
}
