/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.api.repository;

import org.kuali.rice.core.api.mo.common.Coded;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/**
 * Enum for the representation of the Logical Operators AND OR
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public enum LogicalOperator implements Coded {

    /**
     * use this flag with the static factory to get a {@link LogicalOperator} AND
     */
	AND("&"),

    /**
     * use this flag with the static factory to get a {@link LogicalOperator} OR
     */
	OR("|");

	private final String code;

    /**
     * Create the LogicalOperator from the given code
     * @param code to type LogicalOperator as
     */
	private LogicalOperator(String code){
		this.code = code;
	}
	
	@Override
	public String getCode(){
		return code;
	}

    /**
     * Collection&lt;String&gt; OP_CODES
     */
	public static final Collection<String> OP_CODES =
		Collections.unmodifiableCollection(Arrays.asList(AND.code, OR.code));

    /**
     * Collection&lt;String&gt; OP_CODE_NAMES
     */
    public static final Collection<String> OP_CODE_NAMES =
        Collections.unmodifiableCollection(Arrays.asList(AND.name(), OR.name()));

    /**
     * Create a LogicalOperator from the given code
     * @param code used to type LogicalOperator
     * @return LogicalOperator whose code is given
     * @throws IllegalArgumentException if the code does not exist
     */
	public static LogicalOperator fromCode(String code) {
		if (code == null) {
			return null;
		}
		for (LogicalOperator logicalOperator : values()) {
			if (logicalOperator.code.equals(code)) {
				return logicalOperator;
			}
		}
		throw new IllegalArgumentException("Failed to locate the LogicalOperator with the given code: " + code);
	}
	
	@Override
	public String toString(){
		return code;
	}

}
