/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.framework.engine.expression;

import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.engine.expression.ComparisonOperatorService;

/**
 * Contains utility methods for working with the ComparisonOperatorService
 */
public final class ComparisonOperatorServiceUtils {

    // don't allow instances
    private ComparisonOperatorServiceUtils() {
        throw new UnsupportedOperationException();
    }

    /**
     * <P>checks if the value needs to be coerced from a String to another type, and if so it looks for an
     * applicable StringCoercionExtension.</p>
     *
     * @param value the value of the argument that may or may not need coercion
     * @param expectedType the name of the type that the function is expecting for the argument
     * @param comparisonOperatorService the ComparisonOperatorService instance to use (if needed) for finding a StringCoercionExtension
     * @return the coerced value, or the unchanged value if (1) no coercion needs to be done or (2) an applicable
     * StringCoercionExtension can't be found.
     */
    public static Object coerceIfNeeded(Object value, String expectedType, ComparisonOperatorService comparisonOperatorService) {

        Object result = value;

        if (value instanceof String && !"java.lang.String".equals(expectedType)) {
            String valueString = value.toString();
            StringCoercionExtension coercionExtension =
                    comparisonOperatorService.findStringCoercionExtension(expectedType, valueString);
            if (coercionExtension != null) {
                result = coercionExtension.coerce(expectedType, valueString);
            }
        }

        return result;
    }
}
