/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.ui;

import org.kuali.rice.krms.impl.repository.PropositionBo;

import java.io.Serializable;

/**
 * abstract data class for the rule tree {@link Node}s
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class RuleTreeNode implements Serializable {

    private static final long serialVersionUID = 8038174553531544943L;
    public static final String COMPOUND_NODE_TYPE = "ruleTreeNode compoundNode";
    protected PropositionBo proposition;

    public RuleTreeNode(){}
    
    public RuleTreeNode(PropositionBo proposition){
        this.proposition = proposition;
    }
    
    public PropositionBo getProposition() {
        return this.proposition;
    }
    
    public void setProposition(PropositionBo proposition) {
        this.proposition = proposition;
    }

}
