/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.util;

import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;

/**
 * This class contains constants associated with the KRMS Repository 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public final class KRMSPropertyConstants {

	public static final class Action {
		public static final String TYPE ="dataObject.agendaItemLineRuleAction.typeId";
        public static final String NAME ="dataObject.agendaItemLineRuleAction.name";
        public static final String DESCRIPTION ="dataObject.agendaItemLineRuleAction.description";
	}

	public static final class Agenda {
        public static final String NAME = "dataObject.agenda.name";
        public static final String CONTEXT = "dataObject.contextName";
        public static final String TYPE ="dataObject.agenda.typeId";
	}

    public static final class AgendaEditor {
        // used for building binding paths to the custom attributes map
        public static final String CUSTOM_ATTRIBUTES_MAP = "dataObject.customAttributesMap";
        public static final String CUSTOM_RULE_ACTION_ATTRIBUTES_MAP = "dataObject.customRuleActionAttributesMap";
    }
	
	public static final class Context {
		public static final String CONTEXT_ID ="dataObject.id";
		public static final String NAME = "dataObject.name";
		public static final String NAMESPACE = "dataObject.namespace";
		public static final String ATTRIBUTE_BOS = "attributeBos";
	}

    public static final class Term {
        public static final String TERM_ID ="dataObject.id";
        public static final String TERM_SPECIFICATION_ID ="dataObject.specificationId";
        public static final String DESCRIPTION = "dataObject.description";
    }

    public static final class TermSpecification {
        public static final String CATEGORY = "dataObject.categoryId";
        public static final String CONTEXT = "dataObject.contextId";
        public static final String TERM_SPECIFICATION_ID ="dataObject.id";
        public static final String NAME = "dataObject.name";
    }

	public static final class Rule {
		public static final String RULE_ID ="ruleId";
        public static final String NAME = "dataObject.agendaItemLine.rule.name";
        public static final String TYPE = "dataObject.agendaItemLine.rule.typeId";
        public static final String PROPOSITION_TREE_GROUP_ID = "RuleEditorView-Tree";
	}

	public static final class KrmsAttributeDefinition {
		public static final String NAME = "name";
		public static final String NAMESPACE = "namespace";		
	}

	public static final class BaseAttribute {
		public static final String ATTRIBUTE_DEFINITION_ID = "attributeDefinitionId";
		public static final String VALUE = "value";
		public static final String ATTRIBUTE_DEFINITION = "attributeDefinition";
	}

}
