/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.repository;

import org.kuali.rice.kns.inquiry.KualiInquirableImpl;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

import java.util.Map;

/**
 * Helper service to assist with fetching TermSpecificationBos that have all the properties needed for display
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class TermSpecificationInquiryHelperServiceImpl extends KualiInquirableImpl {

    private DataObjectService dataObjectService;

    /**
     * Fetches the TermSpecificationBo for the given id, and manually adds ContextBos for display
     *
     * @param fieldValues the search fields
     * @return the TermSpecificationBo with any contexts mapped by contextValidTerms added
     */
    @Override
    public TermSpecificationBo retrieveDataObject(Map fieldValues) {
        TermSpecificationBo termSpecification = getDataObjectService().find(TermSpecificationBo.class, fieldValues.get("id"));

        if (termSpecification == null) { return null; }

        return termSpecification;
    }

    @Override
    public DataObjectService getDataObjectService() {
        if (dataObjectService == null) {
            return KRADServiceLocator.getDataObjectService();
        }
        return dataObjectService;
    }

    @Override
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}
