/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.uif.container.Container;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.repository.TermParameterBo;
import org.kuali.rice.krms.impl.repository.TermResolverBo;
import org.kuali.rice.krms.impl.repository.TermResolverParameterSpecificationBo;

public class TermMaintainable
extends MaintainableImpl {
    private static final long serialVersionUID = 1L;

    public List<RemotableAttributeField> retrieveCustomAttributes(View view, Object model, Container container) {
        ArrayList<RemotableAttributeField> results = new ArrayList<RemotableAttributeField>();
        String termSpecId = ((TermBo)((MaintenanceDocumentForm)model).getDocument().getNewMaintainableObject().getDataObject()).getSpecificationId();
        QueryResults termResolvers = this.getDataObjectService().findMatching(TermResolverBo.class, QueryByCriteria.Builder.forAttribute((String)"outputId", (Object)termSpecId).build());
        TermResolverBo termResolver = null;
        if (termResolvers.getResults() != null && termResolvers.getResults().size() == 1) {
            termResolver = (TermResolverBo)termResolvers.getResults().get(0);
        }
        if (termResolver != null && !CollectionUtils.isEmpty(termResolver.getParameterSpecifications())) {
            ArrayList<TermResolverParameterSpecificationBo> params = new ArrayList<TermResolverParameterSpecificationBo>(termResolver.getParameterSpecifications());
            Collections.sort(params, new Comparator<TermResolverParameterSpecificationBo>(this){

                @Override
                public int compare(TermResolverParameterSpecificationBo o1, TermResolverParameterSpecificationBo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (TermResolverParameterSpecificationBo param : params) {
                RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)param.getName());
                RemotableTextInput.Builder inputBuilder = RemotableTextInput.Builder.create();
                inputBuilder.setSize(Integer.valueOf(80));
                builder.setControl((RemotableAbstractControl.Builder)inputBuilder);
                builder.setDataType(DataType.STRING);
                builder.setLongLabel(param.getName());
                builder.setShortLabel(param.getName());
                results.add(builder.build());
            }
        }
        return results;
    }

    public Object retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> dataObjectKeys) {
        TermBo termBo = (TermBo)super.retrieveObjectForEditOrCopy(document, dataObjectKeys);
        termBo.exportToParametersMap();
        if ("Copy".equals(this.getMaintenanceAction())) {
            document.getDocumentHeader().setDocumentDescription("New Term Document");
        }
        return termBo;
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterNew(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("New Term Document");
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        super.processAfterEdit(document, requestParameters);
        document.getDocumentHeader().setDocumentDescription("Edited Term Document");
    }

    public void prepareForSave() {
        TermBo term = (TermBo)this.getDataObject();
        if (term.getId() == null) {
            term.setId(MaxValueIncrementerFactory.getIncrementer((DataSource)TermMaintainable.getDataSource(), (String)"KRMS_TERM_S").nextStringValue());
        }
        term.importFromParametersMap();
        for (TermParameterBo param : term.getParameters()) {
            param.setTerm(term);
        }
    }

    public void processAfterRetrieve() {
        super.processAfterRetrieve();
        TermBo term = (TermBo)this.getDataObject();
        term.exportToParametersMap();
    }

    public Class getDataObjectClass() {
        return TermBo.class;
    }

    public void processBeforeAddLine(ViewModel model, Object addLine, String collectionId, String collectionPath) {
        super.processBeforeAddLine(model, addLine, collectionId, collectionPath);
    }

    public static DataSource getDataSource() {
        return (DataSource)GlobalResourceLoader.getService((String)"krmsDataSource");
    }
}

