/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.validation;

import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableRadioButtonGroup;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Utility for creating RemotableRadioButtonGroups given a {@link KrmsAttributeDefinition} and a Map<String, String> of (Radio Button) Values and Labels
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RadioButtonTypeServiceUtil {

    /**
     * RemotableRadioButtonGroups given a {@link KrmsAttributeDefinition} and a Map<String, String> of (Radio Button) Values and Labels.
     * @param krmsAttributeDefinition
     * @param valueLabels
     * @return RemotableAttributeField
     */
    RemotableAttributeField translateTypeAttribute(KrmsAttributeDefinition krmsAttributeDefinition, Map<String, String> valueLabels) {

        RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create(krmsAttributeDefinition.getName());

        RemotableRadioButtonGroup.Builder controlBuilder = RemotableRadioButtonGroup.Builder.create(valueLabels);

        builder.setLongLabel(krmsAttributeDefinition.getLabel());
        builder.setName(krmsAttributeDefinition.getName());
        builder.setRequired(true);
        List<String> defaultValue = new ArrayList<String>();
        defaultValue.add((String) valueLabels.keySet().toArray()[0]); // First value
//        defaultValue.add(valueLabels.get(valueLabels.keySet().toArray()[0])); // First label
//        defaultValue.add("1"); // index
        builder.setDefaultValues(defaultValue);
        builder.setControl(controlBuilder);

        return builder.build();
    }
}
