/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.repository;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

import javax.sql.DataSource;

/**
 * Class used to help migrate KRMS BOs to use DataFieldMaxValueIncrementer
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class RepositoryBoIncrementer {

    private final String seqName;
    private DataFieldMaxValueIncrementer boIncrementer;

    public RepositoryBoIncrementer(String seqName) {
        this.seqName = seqName;
    }

    /**
     * Set the incrementer, useful for testing.
     *
     * @param boIncrementer DataFieldMaxValueIncrementer to use for getNewId()
     */
    public void setDataFieldMaxValueIncrementer(DataFieldMaxValueIncrementer boIncrementer) {
        this.boIncrementer = boIncrementer;
    }

    /**
     * Returns the next available id value.
     *
     * @return String the next available id
     */
    public String getNewId() {
        if (boIncrementer == null) {
            // we don't assign to boIncrementer to preserve existing behavior
            return MaxValueIncrementerFactory.getIncrementer((DataSource) GlobalResourceLoader.getService(
                    "krmsDataSource"), seqName).nextStringValue();
        }

        return boIncrementer.nextStringValue();
    }
}
