/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.repository.jpa;

import org.kuali.rice.krms.api.repository.typerelation.RelationshipType;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

/**
 * A JPA converter that converts String code values to corresponding RelationshipType
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Converter
public class RelationshipTypeConverter implements AttributeConverter<RelationshipType, String> {

    @Override
    public String convertToDatabaseColumn(RelationshipType objectValue) {
        if (objectValue != null) {
            return objectValue.getCode();
        }

        return null;
    }

    @Override
    public RelationshipType convertToEntityAttribute(String dataValue) {
        RelationshipType result = null;

        if (dataValue != null) {
            result = RelationshipType.fromCode(dataValue);
        }

        return result;
    }
}
