/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krms.impl.repository;

import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.view.ViewModel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Helper class that returns all valid types for contexts.
 */
public class ContextTypeValuesFinder extends UifKeyValuesFinderBase {

    @Override
    public List<KeyValue> getKeyValues(ViewModel model) {
        List<KeyValue> keyValues = new ArrayList<KeyValue>();

        // ToDo: Currently we hardcoded any types named "CONTEXT" to be valid with contexts.
        KeyValuesService boService = KNSServiceLocator.getKeyValuesService();
        Map<String,Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("name", "CONTEXT");
        Collection<KrmsTypeBo> types = boService.findMatching(KrmsTypeBo.class, fieldValues);

        for (KrmsTypeBo type : types) {
            keyValues.add(new ConcreteKeyValue(type.getId(), type.getName() + " [" + type.getNamespace() + "]"));
        }

        return keyValues;
    }
}
