/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.serviceexporters;


import org.apache.cxf.Bus;
import org.kuali.rice.ksb.api.bus.ServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.JavaServiceDefinition;
import org.kuali.rice.ksb.api.bus.support.SoapServiceDefinition;

/**
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ServiceExporterFactory {

	public static ServiceExporter getServiceExporter(ServiceDefinition serviceDefinition, Bus cxfBus) {
		
		if (serviceDefinition instanceof JavaServiceDefinition) {
			return new HttpInvokerServiceExporter();
		} else if (serviceDefinition instanceof SoapServiceDefinition) {
			return new SOAPServiceExporter((SoapServiceDefinition)serviceDefinition, cxfBus);
		}
		
		throw new IllegalArgumentException("ServiceDefinition type not supported " + serviceDefinition);
	}
	
	
	
}
