/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging;

import org.springframework.beans.factory.FactoryBean;

/**
 * This class can be used to create a KSBClientProxy.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class KSBClientProxyFactoryBean implements FactoryBean {

    private Class<Object> serviceEndpointInterface;
    private String serviceQName;
    
    @Override
    public Object getObject() throws Exception {
        return KSBClientProxy.newInstance(serviceQName, serviceEndpointInterface);
    }

    @Override
    public Class<Object> getObjectType() {
        return serviceEndpointInterface;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public Class<Object> getServiceEndpointInterface() {
        return serviceEndpointInterface;
    }

    public void setServiceEndpointInterface(Class<Object> serviceInterface) {
        this.serviceEndpointInterface = serviceInterface;
    }

    public String getServiceQName() {
        return serviceQName;
    }

    public void setServiceQName(String serviceQName) {
        this.serviceQName = serviceQName;
    }

}
