/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security.credentials;

import org.kuali.rice.core.api.security.credentials.Credentials;
import org.springframework.util.Assert;

/**
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @since 0.9
 *
 */
public final class UsernamePasswordCredentials implements Credentials {

	private final String username;
	
	private final String password;
	
	public UsernamePasswordCredentials(final String username, final String password) {
		this.username = username;
		this.password = password;
		
		Assert.notNull(this.username, "username cannote be null.");
		Assert.notNull(this.password, "password cannote be null.");
	}

	public String getPassword() {
		return this.password;
	}

	public String getUsername() {
		return this.username;
	}
	
	
	
}
