/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.servlet.ServletController;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

/**
 * An adapter for the {@link ServletController} so that it conforms to Springs MVC {@link Controller} interface. 
 * 
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class CXFServletControllerAdapter implements Controller{

	private ServletController controller;
		
	/**
	 * This method invokes the cxf servlet controller
	 * 
	 * @see org.springframework.web.servlet.mvc.Controller#handleRequest(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
						
        try {
    		BusFactory.setThreadDefaultBus(KSBServiceLocator.getCXFBus());
            controller.invoke(request, response);
        } finally {
            BusFactory.setThreadDefaultBus(null);
        }

		return null;
	}
		
	public void setController(ServletController controller){
		this.controller = controller;
	}
}
