/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.threadpool;

import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;

import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;

/**
 * A comparator to put into the {@link PriorityBlockingQueue} used in the {@link KSBThreadPoolImpl}.
 * 
 *  Determines execution order by priority and create date.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public class PriorityBlockingQueuePersistedMessageComparator implements Comparator {

    
    @Override
    public int compare(Object arg0, Object arg1) {
	if (! (arg0 instanceof MessageServiceInvoker) || ! (arg1 instanceof MessageServiceInvoker) ) {
	    return 0;
	}
	PersistedMessageBO message0 = ((MessageServiceInvoker)arg0).getMessage();
	PersistedMessageBO message1 = ((MessageServiceInvoker)arg1).getMessage();
	
	if (message0.getQueuePriority() < message1.getQueuePriority()) {
	    return -1;
	} else if (message0.getQueuePriority() > message1.getQueuePriority()) {
	    return 1;
	}
	
	if (message0.getQueueDate().before(message1.getQueueDate())) {
	    return -1;
	} else if (message0.getQueueDate().after(message1.getQueueDate())) {
	    return 1;
	}
	
	return 0;
    }

}
