/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security.credentials;

import org.kuali.rice.core.api.security.credentials.Credentials;
import org.kuali.rice.core.api.security.credentials.CredentialsSource;
import org.kuali.rice.core.api.security.credentials.CredentialsType;
import org.springframework.util.Assert;

/**
 * Implementation of a CredentialsSource that contains a username and password.
 * <p>
 * Note that this implementation is for service-to-service authentication. It
 * cannot handle user-to-service authentication.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @since 0.9
 */
public final class UsernamePasswordCredentialsSource implements CredentialsSource {

    /** The username. */
    private final String username;

    /** The password. */
    private final String password;

    @Override
    public Credentials getCredentials(final String serviceEndpoint) {
    	return new UsernamePasswordCredentials(username, password);
	}

	/**
     * Constructor that accepts the username and password for which to construct
     * UsernamePasswordAuthenticationToken's from.
     * 
     * @param username the username.
     * @param password the password.
     */
    public UsernamePasswordCredentialsSource(final String username,
        final String password) {
        Assert.notNull(username, "username cannot be null.");
        Assert.notNull(password, "password cannote be null.");

        this.username = username;
        this.password = password;
    }
    
    @Override
    public CredentialsType getSupportedCredentialsType() {
        return CredentialsType.USERNAME_PASSWORD;
    }
}
