/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.serviceproxies;

import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.util.KSBConstants;
import org.springframework.transaction.support.TransactionSynchronizationManager;


/**
 * Responsible for implementing policy to put message into threadpool for execution appropriately. Could make Spring and
 * overridable service.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * 
 */
final class MessageSender {

    private MessageSender() {
        throw new UnsupportedOperationException("do not call");
    }

    static void sendMessage(PersistedMessageBO message) {
        if (!Boolean.parseBoolean(ConfigContext.getCurrentContextConfig().getProperty(KSBConstants.Config.MESSAGING_OFF))) {
            if (ConfigContext.getCurrentContextConfig().getObject(RiceConstants.SPRING_TRANSACTION_MANAGER) != null
                    || ConfigContext.getCurrentContextConfig().getObject(RiceConstants.TRANSACTION_MANAGER_OBJ) != null) {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    TransactionSynchronizationManager.registerSynchronization(new MessageSendingTransactionSynchronization(message));
                } else {
                    KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(message));
                }
            } else {
                KSBServiceLocator.getThreadPool().execute(new MessageServiceInvoker(message));
            }
        }
    }
}
