/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.security;

import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.cert.Certificate;

import org.apache.commons.codec.binary.Base64;

/**
 * An abstract implementation of a DigitalSigner which provides convienance utilities for storing a reference
 * to the Signature and also generating and encoding the actual digital signature.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public abstract class AbstractDigitalSigner implements DigitalSigner {

	private Signature signature;
	
	public AbstractDigitalSigner(Signature signature) {
		this.signature = signature;
	}
	
	@Override
    public Signature getSignature() {
		return this.signature;
	}
	
	protected byte[] getSignatureBytes() throws Exception {
		return getSignature().sign();
	}
	
    protected String getEncodedSignature() throws Exception {
        return new String(Base64.encodeBase64(getSignatureBytes()), StandardCharsets.UTF_8);
    }

    protected String getEncodedCertificate(Certificate certificate) throws Exception {
        return new String(Base64.encodeBase64(certificate.getEncoded()), StandardCharsets.UTF_8);
    }

}
