/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.ksb.messaging.web;

import org.displaytag.decorator.TableDecorator;

/**
 * A {@link TableDecorator} for the Display Tag library which is used to add mouseover 
 * highlighting to rows in the results on the Document Search screen.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class KSBTableDecorator extends TableDecorator {
    
    @Override
    public String startRow() {
        StringBuffer tbody = new StringBuffer();
        tbody.append("<tbody onmouseover=\"this.className = 'over';\" "); 
        tbody.append("onmouseout=\"this.className = this.className.replace('over', '');\">");
        return tbody.toString();
    }    
    
    @Override
    public String finishRow() {
        return "</tbody>";
    }
    
}
