/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.api;

import org.kuali.rice.core.api.CoreConstants;

/**
 * <p>LocationConstants class.</p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public final class LocationConstants {

    public static final String NAMESPACE_CODE = "KR-LOC";

    public final static class PrimaryKeyConstants {
		public static final String CODE = "code";
        public static final String COUNTRY_CODE = "countryCode";
		public static final String STATE_CODE = "stateCode";

        private PrimaryKeyConstants() {
			throw new UnsupportedOperationException("do not call");
		}
    }

    public final static String LOCATION_DISTRIBUTED_CACHE = "locationDistributedCacheManager";
    public final static String SERVICE_PATH_SOAP = "soap/" + Namespaces.MODULE_NAME + "/" + CoreConstants.Versions.VERSION_2_0;

    public static final class Namespaces {
    	public static final String MODULE_NAME = "location";
        public static final String LOCATION_NAMESPACE_PREFIX = CoreConstants.Namespaces.ROOT_NAMESPACE_PREFIX + "/" + MODULE_NAME;
    	/**
    	 * Namespace for the core module which is compatible with Kuali Rice 2.0.x.
    	 */
    	public static final String LOCATION_NAMESPACE_2_0 = LOCATION_NAMESPACE_PREFIX + "/" + CoreConstants.Versions.VERSION_2_0;

        private Namespaces() {
		    throw new UnsupportedOperationException("do not call");
	    }
    }

    public static class ParameterKey {
        public static final String DEFAULT_COUNTRY = "DEFAULT_COUNTRY";
    }
}
