/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.location.web.state;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.impl.cache.DistributedCacheManagerDecorator;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.location.api.LocationConstants;
import org.kuali.rice.location.api.state.State;

public class StateMaintainableImpl extends KualiMaintainableImpl {
    @Override
    public void saveDataObject() {
        super.saveDataObject();

        //flush cache
        DistributedCacheManagerDecorator distributedCacheManagerDecorator =
                GlobalResourceLoader.getService(LocationConstants.LOCATION_DISTRIBUTED_CACHE);
        distributedCacheManagerDecorator.getCache(State.Cache.NAME).clear();
    }

}
