<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="responsibilityAttributes" value="${DataDictionary.UberResponsibilityBo.attributes}" />

<kul:tab tabTitle="Responsibilities" defaultOpen="true" tabErrorKey="document.resp*">
	<div class="tab-container" align="center">
    
    <table cellpadding="0" cellspacing="0" summary="">
          <c:if test="${!readOnly}">	
          	
             <tr>
				<td align="center">
	                <div align="center">
	                	<br/>
						<b>Add Responsibility ID:</b>
						<kul:htmlControlAttribute property="responsibility.responsibilityId" attributeEntry="${responsibilityAttributes.id}"/>
	                	<kul:lookup boClassName="org.kuali.rice.kim.impl.responsibility.UberResponsibilityBo"
									lookupParameters="responsibility.responsibilityId:id,responsibility.kimResponsibility.template.name:template.name,responsibility.kimResponsibility.name:name,responsibility.kimResponsibility.namespaceCode:namespaceCode"
									fieldConversions="id:responsibility.responsibilityId,template.name:responsibility.kimResponsibility.template.name,name:responsibility.kimResponsibility.name,namespaceCode:responsibility.kimResponsibility.namespaceCode"
									anchor="${tabKey}" />
						<html:hidden property="responsibility.name" />
						<html:hidden property="responsibility.namespaceCode" />
						${KualiForm.responsibility.namespaceCode}&nbsp;&nbsp;${KualiForm.responsibility.name}&nbsp;
	                	<br/>
	                	<br/>
		            </div>
				</td>
			</tr>
			<tr>                                
                <td class="infoline">
					<div align="center">
						<kul:kualiButton property="methodToCall.addResponsibility.anchor${tabKey}"
									src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
									label="Add" title="Add Responsibility" styleClass="tinybutton small outline"/>
					</div>
                </td>
	       </tr>         
     </c:if>       
	</table>
	<table cellpadding="0" cellspacing="0" summary="">
        	<tr>
        		<th>&nbsp;</th> 
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.namespaceCode}" noColon="true" /></div></th>
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.id}" noColon="true" /></div></th>
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.name}" noColon="true" /></div></th>
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.detailObjectsValues}" noColon="true" /></div></th>
        		<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.active}" noColon="true" /></div></th>
				<c:if test="${!readOnly}">	
            		<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
				</c:if>	
        	</tr>     
      	<c:forEach var="responsibility" items="${KualiForm.document.responsibilities}" varStatus="status">
       	    <c:set var="rows" value="1"/>
       		<c:if test="${responsibility.roleRspAction.roleResponsibilityId!=null}">	
        	       <c:set var="rows" value="2"/>
       		</c:if>        	
            <tr>
				<th rowspan="${rows}" class="infoline" valign="top">
					<c:out value="${status.index+1}" />
				</th>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].kimResponsibility.namespaceCode"  attributeEntry="${responsibilityAttributes.namespaceCode}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].responsibilityId"  attributeEntry="${responsibilityAttributes.id}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].kimResponsibility.name"  attributeEntry="${responsibilityAttributes.name}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left">  <kul:htmlControlAttribute property="document.responsibilities[${status.index}].kimResponsibility.detailObjectsToDisplay"  attributeEntry="${responsibilityAttributes.detailObjectsToDisplay}" readOnly="true"  />
					</div>
				</td>
				<c:choose>
					<c:when test="${responsibility.edit && !readOnly}">
			            <td align="center" valign="middle">
			               	<div align="center"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].active"  attributeEntry="${responsibilityAttributes.active}" />
							</div>
						</td>
					</c:when>
       	       		<c:otherwise>
			            <td align="center" valign="middle">
			               	<div align="center"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].active"  attributeEntry="${responsibilityAttributes.active}" readOnly="true"  />
							</div>
						</td>
        	       	</c:otherwise>
       	     	</c:choose>  
			<c:if test="${!readOnly}">	
				<td>
					<div align=center>&nbsp;
						<kul:kualiButton property="methodToCall.deleteResponsibility.line${status.index}.anchor${currentTabIndex}"
										 src="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete1.gif"
										 disabledSrc="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete2.gif"
										 label="Delete" title="Delete Responsibility" styleClass="tinybutton small outline"
										 disabled="${responsibility.edit}" />
					</div>
				</td>
			</c:if>    
			</tr>
	        <c:if test="${responsibility.roleRspAction != null}">	
    			<tr>
	              <td colspan="7" style="padding:0px;">
	              	<kim:responsibilityAction responsibilityIdx="${status.index}" />
		          </td>
		        </tr>
			</c:if>	 
		</c:forEach>        
	</table>
	</div>
</kul:tab>
