<%--
  #%L
  %%
  Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="userIdFieldName" required="true" description="The name of the property which will be populated with the principal name." %>
<%@ attribute name="universalIdFieldName" required="true" description="The name of the field which will be populated with the principal id." %>
<%@ attribute name="userNameFieldName" required="true" description="The field which will be populated with the principal name, for displaying." %>
<%@ attribute name="userId" required="true" description="The passed in principal name." %>
<%@ attribute name="universalId" required="true" description="The passed in principal id." %>
<%@ attribute name="userName" required="true" description="The passed in principal name, for display." %>

<%@ attribute name="label" required="false" description="The label to be shown on the linked lookup screen." %>
<%@ attribute name="fieldConversions" required="false" description="Pre-set values to populate within the lookup form." %>
<%@ attribute name="lookupParameters" required="false" description="On return from lookup, these parameters describe which attributes of the business object to populate in the lookup parent." %>
<%@ attribute name="referencesToRefresh" required="false" description="On return from the lookup, the references on the parent business object which will be refreshed." %>

<%@ attribute name="hasErrors" required="false" description="Whether an error icon should be displayed by the field or not." %>
<%@ attribute name="readOnly" required="false" description="Whether this field should be displayed as read only or not." %>
<%@ attribute name="onblur" required="false" description="Javascript code which will be executed with the input field's onblur event is triggered." %>
<%@ attribute name="onchange" required="false" description="Javascript code which will be executed with the input field's onchange event is triggered." %>

<%@ attribute name="helpLink" required="false" description="HTML - not just a URL - to be displayed next to the input field, presumably linking to a help resource." %>

<%@ attribute name="highlight" required="false"
              description="boolean indicating if this field is rendered as highlighted (to indicate old/new value change)" %> 
<%@ attribute name="tabIndex" required="false" description="Tab index to use for next field" %>

<%-- if the universal user ID field is a key field on this document, lock-down the user ID field --%>
<c:choose>
  <c:when test="${readOnly}">
    <input type="hidden" id='<c:out value="${userIdFieldName}"/>' name='<c:out value="${userIdFieldName}"/>' value='<c:out value="${userId}"/>' />
    <kul:inquiry boClassName="org.kuali.rice.kim.api.identity.Person" keyValues="principalId=${universalId}&principalName=${userId}" render="true"><c:out value="${userId}" /></kul:inquiry>&nbsp;
  </c:when>
  <c:otherwise>
    ${kfunc:registerEditableProperty(KualiForm, userIdFieldName)}
    <input type="text" id='<c:out value="${userIdFieldName}"/>' name='<c:out value="${userIdFieldName}"/>' value='<c:out value="${userId}"/>'
    title='${DataDictionary.PersonImpl.attributes.principalName.label}'
    size='${DataDictionary.PersonImpl.attributes.principalName.control.size}' 
    maxlength='${DataDictionary.PersonImpl.attributes.principalName.maxLength}' style="${textStyle}"
    onBlur="loadUserInfo( '${userIdFieldName}', '${universalIdFieldName}', '${userNameFieldName}' );${onblur}" onchange="${onchange}" tabIndex="${tabIndex}"/>
    <c:if test="${hasErrors}">
     <kul:fieldShowErrorIcon />
    </c:if>
    <kul:lookup boClassName="org.kuali.rice.kim.api.identity.Person"
          fieldConversions="${fieldConversions}" 
          lookupParameters="${lookupParameters}" 
          fieldLabel="${label}" 
          referencesToRefresh="${referencesToRefresh}"
          anchor="${currentTabIndex}" />
  </c:otherwise>
</c:choose>
<c:choose>
  <c:when test="${readOnly}">
    -
  </c:when>
  <c:otherwise>
    ${helpLink}
    <br />
  </c:otherwise>
</c:choose>
<c:choose>
    <c:when test="${!empty userNameFieldName}">
        <span id="${userNameFieldName}.div">${userName}&nbsp;</span>
    </c:when>
    <c:otherwise><%-- guess at the name if the name field is not being rendered --%>
        <span id='${fn:replace( userIdFieldName, ".principalName", ".name" )}.div'>${userName}&nbsp;</span>
        <%-- When the user name field is not set, most likely, the name is not passed through
             (It is also not available to be passed in, since only the Field objects are present
             for use by rowDisplay.tag.  So, we fire off the needed JS to update the name. --%>
        <c:if test="${empty userName && !(empty userId)}">
            <script type="text/javascript">loadUserInfo( "${userIdFieldName}", "", "" );</script>
        </c:if>
    </c:otherwise>
</c:choose>
  
<c:if test="${!empty universalIdFieldName}">
  ${kfunc:registerEditableProperty(KualiForm, universalIdFieldName)}
  <input type="hidden" name="${universalIdFieldName}" id="${universalIdFieldName}" value="${universalId}" />
</c:if>
<c:if test="${!empty userNameFieldName}">
  ${kfunc:registerEditableProperty(KualiForm, userNameFieldName)}
  <input type="hidden" name="${userNameFieldName}" id="${userNameFieldName}" value="${userName}" />
</c:if>

<c:if test="${highlight}">
<kul:fieldShowChangedIcon/>
</c:if>
