/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.JSqlParserCache;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration$FailureReason;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.repackaged.net.sf.jsqlparser.JSQLParserException;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class TableColumnCountWarning
extends AbstractLiquibaseDynamicForecastRule {
    public TableColumnCountWarning() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public String getName() {
        return "Check Table Column Count";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "TableColumnLimit";
    }

    private boolean doEvaluate(List<Change> object, ChangeSet changeSet, DynamicRule dynamicRule, boolean bl2) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Change)object.next();
            Integer n2 = (Integer)dynamicRule.getParameters().get(0).getValue();
            if (object2 instanceof CreateTableChange) {
                if (!this.doTableColumnCountCheck((CreateTableChange)object2, (int)n2)) continue;
                this.addErrorMessage(changeSet, n2, dynamicRule, bl2);
                continue;
            }
            if (!(object2 instanceof AbstractSQLChange)) continue;
            try {
                if (!((object2 = JSqlParserCache.parseSql(this.getSql((AbstractSQLChange)object2), true)) instanceof CreateTable) || !this.doTableColumnCountCheck((CreateTable)object2, (int)n2)) continue;
                this.addErrorMessage(changeSet, n2, dynamicRule, bl2);
            }
            catch (JSQLParserException jSQLParserException) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to parse SQL", (Throwable)jSQLParserException);
                this.addFailureRuleIteration(changeSet, "Some or all of the SQL could not be parsed by this check. Please review the changeset or SQL directly to make sure it is valid.", RuleIteration$FailureReason.SQL_PARSING, dynamicRule, bl2);
            }
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, bl2);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, dynamicRule, false);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> list, Database database, DynamicRule dynamicRule) {
        return this.doEvaluate(list, changeSet, dynamicRule, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        Integer n2 = (Integer)dynamicRule.getParameters().get(0).getValue();
        if (databaseObject instanceof Table && this.doTableColumnCountCheck((Table)databaseObject, (int)n2)) {
            this.addErrorMessage(databaseObject, n2, dynamicRule);
        }
        return this.returnAtEndOfRule(databaseObject, dynamicRule);
    }

    private void addErrorMessage(ChangeSet changeSet, Integer n2, DynamicRule dynamicRule, boolean bl2) {
        String string = this.determinePlurality(n2);
        this.addFailureRuleIteration(changeSet, String.format("Table must not have more than %d %s.", n2, string), dynamicRule, bl2);
    }

    private void addErrorMessage(DatabaseObject databaseObject, Integer n2, DynamicRule dynamicRule) {
        String string = this.determinePlurality(n2);
        this.addFailureRuleIteration(databaseObject, String.format("Table %s must not have more than %d %s.", databaseObject.getName(), n2, string), dynamicRule);
    }

    private String determinePlurality(Integer n2) {
        if (n2 == 1) {
            return "column";
        }
        return "columns";
    }

    private boolean doTableColumnCountCheck(CreateTableChange createTableChange, int n2) {
        return createTableChange.getColumns().size() > n2;
    }

    private boolean doTableColumnCountCheck(Table table, int n2) {
        return table.getColumns().size() > n2;
    }

    private boolean doTableColumnCountCheck(CreateTable createTable, int n2) {
        return createTable.getColumnDefinitions().size() > n2;
    }

    @Override
    public String getDescription() {
        return "Ensures that no table has more than a threshold number of columns.";
    }

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Collections.singletonList(new RuleParameter(DynamicRuleParameterEnum.MAX_COLUMNS));
    }
}

