/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.changelog.AbstractChangeGenerator;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

public abstract class AbstractMissingStoredLogicChangeGenerator
extends AbstractChangeGenerator
implements MissingObjectChangeGenerator {
    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class, View.class, Column.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (!LicenseServiceUtils.isProLicenseValid()) {
            return -1;
        }
        return 1;
    }

    public static Change[] wrapWithQuotedIdentifier(DatabaseObject object, Database database, Change[] changeArray) {
        if (!(database instanceof MSSQLDatabase)) {
            return changeArray;
        }
        if (!((Boolean)object.getAttribute("usesQuotedIdentifier", (Object)Boolean.TRUE)).booleanValue()) {
            object = new ArrayList<Change>(Arrays.asList(changeArray));
            object.add(0, (Change)new RawSQLChange("SET QUOTED_IDENTIFIER OFF"));
            object.add(new RawSQLChange("SET QUOTED_IDENTIFIER ON"));
            Object object2 = object;
            return object2.toArray(new Change[object2.size()]);
        }
        return changeArray;
    }

    public static <T extends Change> T findChange(Class<T> clazz, Change[] changeArray) {
        for (Change change : changeArray) {
            if (!clazz.isAssignableFrom(change.getClass())) continue;
            return (T)change;
        }
        return null;
    }
}

