/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.trigger.MissingTriggerChangeGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.license.LicenseServiceUtils;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class MissingTriggerExternalFileChangeGenerator
extends MissingTriggerChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (!((Boolean)LiquibaseProConfiguration.INLINE_SQL_KEY.getCurrentValue()).booleanValue() && Trigger.class.isAssignableFrom(clazz)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return super.getPriority(clazz, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject object, DiffOutputControl changeArray, Database object2, Database object3, ChangeGeneratorChain changeGeneratorChain) {
        changeArray = super.fixMissing((DatabaseObject)object, (DiffOutputControl)changeArray, (Database)object2, (Database)object3, changeGeneratorChain);
        object2 = MissingTriggerExternalFileChangeGenerator.findChange(CreateTriggerChange.class, changeArray);
        object2.setRelativeToChangelogFile(Boolean.TRUE);
        object = (Trigger)((Object)object);
        object3 = object.getTableName();
        if (object3 != null) {
            object3 = "trigger/" + (String)object3 + "_" + object.getName() + ".sql";
        }
        Object object4 = object;
        object2.setPath(ObjectSqlFileUtil.writeObjectSql(object4, object4.getBody(), (String)object3));
        ((CreateTriggerChange)((Object)object2)).setTriggerBody(null);
        return changeArray;
    }
}

