/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.TriggerSnapshotGenerator$1;
import com.datical.liquibase.ext.storedlogic.trigger.postgres.PostgresTriggerSnapshotGenerator;
import java.util.Collection;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtil;
import liquibase.util.StringUtil;

public class TriggerSnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    public TriggerSnapshotGenerator() {
        super(Trigger.class, new Class[]{Schema.class, Catalog.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof DB2Database || database instanceof Db2zDatabase || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    @Override
    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) {
        databaseSnapshot = databaseSnapshot.getDatabase();
        if (databaseObject instanceof Catalog && databaseSnapshot instanceof MSSQLDatabase || databaseObject instanceof Catalog && databaseSnapshot instanceof PostgresDatabase || databaseObject instanceof Schema) {
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)databaseSnapshot);
            Object object2 = this.getSnapshotObjectSql(databaseObject, (Database)databaseSnapshot);
            if (object2 == null || ((String)object2).isEmpty()) {
                return;
            }
            for (Object object2 : executor.queryForList((SqlStatement)new RawSqlStatement((String)object2))) {
                if ((object2 = this.rowToObject((Map<?, ?>)object2, databaseObject, (Database)databaseSnapshot)) == null || databaseSnapshot.isSystemObject((DatabaseObject)object2)) continue;
                if (databaseObject instanceof Schema) {
                    ((Schema)databaseObject).addDatabaseObject((DatabaseObject)object2);
                    continue;
                }
                ((Catalog)databaseObject).addDatabaseObject((DatabaseObject)object2);
            }
        }
    }

    protected String getSnapshotObjectSql(DatabaseObject databaseObject, Database database) {
        String string;
        if (database instanceof PostgresDatabase) {
            return new PostgresTriggerSnapshotGenerator().getSnapshotObjectSql(databaseObject, database);
        }
        if (database instanceof MSSQLDatabase) {
            string = "SELECT sys.triggers.name AS OBJECT_NAME, OBJECT_DEFINITION(sys.triggers.object_id) AS OBJECT_BODY, sys.triggers.create_date AS CREATED, sys.triggers.modify_date AS LAST_MODIFIED, 'VALID' as STATUS, IS_DISABLED as IS_DISABLED, parent.name as TABLE_NAME, uses_quoted_identifier FROM sys.triggers LEFT OUTER JOIN sys.objects on sys.objects.object_id=sys.triggers.object_id LEFT OUTER JOIN sys.all_objects parent ON triggers.parent_id = parent.object_id LEFT OUTER JOIN sys.sql_modules ON sql_modules.object_id=triggers.object_id";
            if (!(databaseObject instanceof Catalog)) {
                String string2 = ((MSSQLDatabase)database).getJdbcSchemaName(databaseObject.getSchema().toCatalogAndSchema());
                if (string2 == null) {
                    string2 = database.getDefaultSchemaName();
                }
                string = string + " INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and sys.schemas.name='" + string2 + "' ";
            }
            if (databaseObject instanceof Trigger) {
                string = string + " where sys.triggers.name='" + database.correctObjectName(databaseObject.getName(), Trigger.class) + "'";
            } else if (databaseObject instanceof Schema) {
                string = String.valueOf(string);
            } else if (databaseObject instanceof Catalog) {
                string = string + " where parent_class=0";
            }
        } else if (database instanceof DB2Database) {
            string = "SELECT TRIGNAME AS OBJECT_NAME, CREATE_TIME AS CREATED, ALTER_TIME AS LAST_MODIFIED, VALID AS STATUS, TEXT AS OBJECT_BODY, TABNAME AS TABLE_NAME, ENABLED FROM SYSCAT.TRIGGERS WHERE TRIGSCHEMA='" + database.correctObjectName(databaseObject.getSchema().getCatalogName(), Catalog.class) + "'";
            try {
                if (database.getDatabaseMajorVersion() < 10) {
                    string = string.replace("ALTER_TIME AS LAST_MODIFIED,", "");
                    string = string.replace("ENABLED", "'Y' AS ENABLED");
                }
            }
            catch (DatabaseException databaseException) {}
            if (databaseObject instanceof Trigger) {
                string = string + " AND TRIGNAME='" + database.correctObjectName(databaseObject.getName(), Trigger.class) + "'";
            }
        } else if (database instanceof Db2zDatabase) {
            string = "SELECT NAME AS OBJECT_NAME, CREATEDTS AS CREATED, ALTEREDTS AS LAST_MODIFIED, 'Y' AS STATUS, STATEMENT AS OBJECT_BODY, TBNAME AS TABLE_NAME, 'Y' AS ENABLED FROM SYSIBM.SYSTRIGGERS WHERE SCHEMA='" + database.correctObjectName(databaseObject.getSchema().getCatalogName(), Catalog.class).toUpperCase() + "'";
            if (databaseObject instanceof Trigger) {
                string = string + " AND NAME='" + database.correctObjectName(databaseObject.getName(), Trigger.class).toUpperCase() + "'";
            }
        } else if (database instanceof OracleDatabase) {
            string = "select OBJECT_NAME, CREATED, LAST_DDL_TIME AS LAST_MODIFIED, ALL_OBJECTS.STATUS, ALL_TRIGGERS.STATUS as TRIGGER_STATUS, trigger_body AS OBJECT_BODY, ACTION_TYPE, WHEN_CLAUSE, REFERENCING_NAMES, COLUMN_NAME, TABLE_NAME, BASE_OBJECT_TYPE, all_triggers.owner as TRIGGER_OWNER, TABLE_OWNER, TRIGGERING_EVENT, TRIGGER_TYPE, DESCRIPTION as TRIGGER_DESCRIPTION from ALL_OBJECTS join all_triggers on trigger_name=object_name and all_triggers.owner=all_objects.owner where object_type='TRIGGER' and all_triggers.owner='" + database.correctObjectName(databaseObject.getSchema().getCatalogName(), Catalog.class) + "'";
            if (databaseObject instanceof Trigger) {
                String string3 = database.correctObjectName(databaseObject.getName(), Trigger.class);
                string = string + " and trigger_name='" + string3 + "'";
            }
        } else if (database instanceof MySQLDatabase) {
            String string4 = databaseObject.getSchema().getName();
            string = "select action_statement as OBJECT_BODY, trigger_name as OBJECT_NAME, event_object_table as TABLE_NAME, event_object_schema as TABLE_OWNER, event_manipulation as TRIGGERING_EVENT, action_timing as WHEN_CLAUSE FROM INFORMATION_SCHEMA.TRIGGERS WHERE trigger_schema = '" + string4 + "';";
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database for trigger snapshot: " + database.getShortName());
        }
        return string;
    }

    @Override
    protected String getAddToSql(Schema object, Database database) {
        if (database instanceof PostgresDatabase) {
            return new PostgresTriggerSnapshotGenerator().getAddToSql((Schema)object, database);
        }
        if (database instanceof MSSQLDatabase) {
            if ((object = ((MSSQLDatabase)database).getJdbcSchemaName(object.toCatalogAndSchema())) == null) {
                object = database.getDefaultSchemaName();
            }
            return "SELECT  sys.objects.name AS OBJECT_NAME FROM sys.objects INNER JOIN sys.schemas ON sys.objects.schema_id = sys.schemas.schema_id and sys.schemas.name='" + (String)object + "' where type_desc='SQL_TRIGGER'";
        }
        if (database instanceof DB2Database) {
            return "SELECT TRIGNAME AS OBJECT_NAME FROM SYSCAT.TRIGGERS WHERE TRIGSCHEMA='" + ((DB2Database)database).getJdbcSchemaName(object.toCatalogAndSchema()) + "'";
        }
        if (database instanceof Db2zDatabase) {
            return "SELECT NAME AS OBJECT_NAME FROM SYSIBM.SYSTRIGGERS WHERE SCHEMA='" + ((Db2zDatabase)database).getJdbcSchemaName(object.toCatalogAndSchema()) + "'";
        }
        if (database instanceof MySQLDatabase) {
            object = ((MySQLDatabase)database).getJdbcSchemaName(object.toCatalogAndSchema());
            return "SELECT TRIGGER_NAME as OBJECT_NAME FROM INFORMATION_SCHEMA.TRIGGERS WHERE TRIGGER_SCHEMA='" + (String)object + "'";
        }
        return super.getAddToSql((Schema)object, database);
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) {
        Trigger trigger = (Trigger)databaseObject;
        if (trigger.getBody() == null) {
            databaseSnapshot = databaseSnapshot.getDatabase();
            Object object = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)databaseSnapshot);
            String string = this.getSnapshotObjectSql(databaseObject, (Database)databaseSnapshot);
            if ((object = object.queryForList((SqlStatement)new RawSqlStatement(string))).size() == 0) {
                return null;
            }
            try {
                JdbcUtil.requiredSingleResult((Collection)object);
            }
            catch (DatabaseException databaseException) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error snapshotting " + (Object)((Object)trigger) + " with result set of " + string, (Throwable)databaseException);
                throw databaseException;
            }
            object = (Map)object.get(0);
            return this.rowToObject((Map<?, ?>)object, (DatabaseObject)databaseObject.getSchema(), (Database)databaseSnapshot);
        }
        return databaseObject;
    }

    private Trigger rowToObject(Map<?, ?> map, DatabaseObject object, Database database) {
        String string = (String)map.get("OBJECT_BODY");
        String string2 = (String)map.get("OBJECT_NAME");
        Boolean bl2 = database instanceof AbstractDb2Database ? Boolean.valueOf(map.get("STATUS").equals("Y")) : (database instanceof MySQLDatabase ? Boolean.TRUE : Boolean.valueOf(map.get("STATUS").equals("VALID")));
        boolean bl3 = database instanceof OracleDatabase || database instanceof PostgresDatabase ? !map.get("TRIGGER_STATUS").equals("ENABLED") : (database instanceof AbstractDb2Database ? !map.get("ENABLED").equals("Y") : (database instanceof MySQLDatabase ? false : (Boolean)map.get("IS_DISABLED")));
        String string3 = (String)map.get("ACTION_TYPE");
        String string4 = (String)map.get("WHEN_CLAUSE");
        String string5 = (String)map.get("REFERENCING_NAMES");
        String string6 = (String)map.get("COLUMN_NAME");
        String string7 = (String)map.get("TABLE_NAME");
        String string8 = (String)map.get("BASE_OBJECT_TYPE");
        String string9 = (String)map.get("TABLE_OWNER");
        String string10 = (String)map.get("TRIGGERING_EVENT");
        String string11 = (String)map.get("TRIGGER_TYPE");
        Schema schema = null;
        Catalog catalog = null;
        if (object instanceof Schema) {
            schema = (Schema)object;
        } else {
            catalog = (Catalog)object;
        }
        if (string == null) {
            try {
                object = string2;
                if (schema != null) {
                    object = schema + "." + (String)object;
                }
                if ((object = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawSqlStatement("SELECT sp.name AS [sp_name], schema_name(sp.schema_id) as schema_name, table_obj.name as [table_name], schema_name(table_obj.schema_id) as [table_schema], events.type_desc as [type_desc], sp.type as object_type, case when amsp.object_id is null then N'''' else asmblsp.name end AS [AssemblyName], case when amsp.object_id is null then N'''' else amsp.assembly_class end AS [ClassName], case when amsp.object_id is null then N'''' else amsp.assembly_method end AS [MethodName], sp.object_id AS [object_id] FROM sys.all_objects AS sp JOIN sys.triggers AS triggers on triggers.object_id=sp.object_id LEFT OUTER JOIN sys.objects AS table_obj on table_obj.object_id=triggers.parent_id LEFT OUTER JOIN sys.assembly_modules AS amsp ON amsp.object_id = sp.object_id LEFT OUTER JOIN sys.assemblies AS asmblsp ON asmblsp.assembly_id = amsp.assembly_id LEFT OUTER JOIN sys.events AS events ON events.object_id = sp.object_id WHERE sp.object_id=object_id('" + (String)object + "')"))).size() > 0) {
                    Map map2 = (Map)object.get(0);
                    string = "CREATE TRIGGER " + this.alwaysQuoteDatabaseObject(null, (String)map2.get("SCHEMA_NAME"), (String)map2.get("SP_NAME"), Trigger.class, database) + " ON " + this.alwaysQuoteDatabaseObject(null, (String)map2.get("TABLE_SCHEMA"), (String)map2.get("TABLE_NAME"), Table.class, database) + " FOR ";
                    string = string + StringUtil.join((Collection)object, (String)", ", (StringUtil.StringUtilFormatter)new TriggerSnapshotGenerator$1(this));
                    string = string + " AS EXTERNAL NAME " + map2.get("ASSEMBLYNAME") + ".[" + map2.get("CLASSNAME") + "]." + map2.get("METHODNAME");
                }
            }
            catch (DatabaseException databaseException) {
                throw new RuntimeException(databaseException);
            }
        }
        if (string == null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Omitting " + this.getObjectType(database).toLowerCase() + " '" + string2 + "': OBJECT_BODY is null. Null OBJECT_BODY values are often due to permission issues");
            return null;
        }
        string = StringUtil.trimToNull((String)StringUtil.trimToEmpty((String)string.replaceAll("\r\n", "\n").replaceAll("\r", "\n")));
        if (database instanceof OracleDatabase) {
            object = ((String)map.get("TRIGGER_DESCRIPTION")).replaceFirst("(?i)\"?" + map.get("TRIGGER_OWNER") + "\"?\\.", "");
            if (string4 != null) {
                object = (String)object + "WHEN (" + string4 + ") ";
            }
            string = "CREATE OR REPLACE TRIGGER " + (String)object + string;
        } else if (database instanceof MySQLDatabase) {
            string = "CREATE TRIGGER " + string2 + " " + string4 + " " + string10 + " ON " + string7 + " FOR EACH ROW " + string + "\n";
        }
        object = null;
        if (string9 != null) {
            object = new Schema(string9, null);
        }
        object = ((Trigger)((Trigger)((Trigger)((Trigger)new Trigger().setSchema(schema)).setCatalog(catalog).setName(string2)).setValid(bl2)).setBody(string)).setDisabled(bl3).setActionType(string3).setWhenClause(string4).setReferencingNames(string5).setColumnName(string6).setTableName(string7).setBaseObjectType(string8).setTableSchema((Schema)object).setTriggeringEvent(string10).setTriggerType(string11);
        if (database instanceof MSSQLDatabase) {
            object.setAttribute("usesQuotedIdentifier", map.get("USES_QUOTED_IDENTIFIER"));
        }
        return object;
    }

    @Override
    protected String getObjectType(Database database) {
        return "TRIGGER";
    }

    @Override
    protected StoredDatabaseLogic<?> createReturnObject() {
        return new Trigger();
    }
}

