/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerStatement;
import com.datical.liquibase.ext.storedlogic.trigger.change.DisableTriggerChange;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.SqlParser;

public class CreateTriggerGenerator
extends AbstractSqlGenerator<CreateTriggerStatement> {
    public int getPriority() {
        return 101;
    }

    public ValidationErrors validate(CreateTriggerStatement createTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        sqlGeneratorChain = new ValidationErrors();
        sqlGeneratorChain.checkRequiredField("triggerName", (Object)createTriggerStatement.getTriggerName());
        sqlGeneratorChain.checkRequiredField("triggerBody", (Object)createTriggerStatement.getTriggerBody());
        sqlGeneratorChain.checkDisallowedField("catalogName", (Object)createTriggerStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        return sqlGeneratorChain;
    }

    public boolean supports(CreateTriggerStatement createTriggerStatement, Database database) {
        return !(database instanceof CockroachDatabase);
    }

    public Sql[] generateSql(CreateTriggerStatement createTriggerStatement, Database database, SqlGeneratorChain object) {
        Object object2;
        object = ";";
        if (database instanceof OracleDatabase) {
            object = "\n/";
        } else if (database instanceof AbstractDb2Database) {
            object = "";
        }
        String string = createTriggerStatement.getSchemaName();
        if (string == null && database instanceof PostgresDatabase) {
            string = database.getDefaultSchemaName();
        }
        string = CreateProcedureGenerator.removeTrailingDelimiter((String)CreateProcedureGenerator.addSchemaToText((String)createTriggerStatement.getTriggerBody(), (String)string, (String)"ON", (Database)database), (String)object);
        if (this.needAppendSchemaName(database)) {
            string = CreateProcedureGenerator.addSchemaToText((String)string, (String)createTriggerStatement.getSchemaName(), (String)"TRIGGER", (Database)database);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (createTriggerStatement.getReplaceIfExists() != null && createTriggerStatement.getReplaceIfExists().booleanValue()) {
            if (database instanceof MSSQLDatabase) {
                object2 = database.escapeObjectName(createTriggerStatement.getTriggerName(), Trigger.class);
                object2 = createTriggerStatement.getSchemaName() == null ? "[dbo].".concat(String.valueOf(object2)) : database.escapeObjectName(createTriggerStatement.getSchemaName(), Schema.class) + "." + (String)object2;
                if (createTriggerStatement.getTableName() == null) {
                    arrayList.add(new UnparsedSql("if (select count(*) from sys.triggers where parent_class_desc='DATABASE' and name='" + database.escapeStringForDatabase(createTriggerStatement.getTriggerName()) + "') = 0 exec ('CREATE TRIGGER " + database.escapeObjectName(createTriggerStatement.getTriggerName(), Trigger.class) + " on DATABASE FOR DROP_TABLE as begin select ''STUB'' END')", new DatabaseObject[0]));
                } else {
                    arrayList.add(new UnparsedSql("if object_id('" + (String)object2 + "', 'tr') is null exec ('CREATE TRIGGER " + database.escapeObjectName(createTriggerStatement.getTriggerName(), Trigger.class) + " on " + database.escapeObjectName(createTriggerStatement.getCatalogName(), createTriggerStatement.getSchemaName(), createTriggerStatement.getTableName(), Table.class) + " after insert as begin select ''STUB'' END')", new DatabaseObject[0]));
                }
                string = SqlParser.parse((String)string, (boolean)true, (boolean)true);
                object2 = string.getClauseIterator();
                Object object3 = "START";
                while (object3 != null && !object3.toString().equalsIgnoreCase("create") && !object3.toString().equalsIgnoreCase("alter") && object2.hasNext()) {
                    object3 = object2.nextNonWhitespace();
                }
                object2.replace((Object)"ALTER");
                string = string.toString();
            } else {
                object2 = database.escapeObjectName(createTriggerStatement.getProcedureName(), Trigger.class);
                arrayList.add(new UnparsedSql("DROP TRIGGER IF EXISTS ".concat(String.valueOf(object2)), new DatabaseObject[0]));
            }
        }
        arrayList.add(new UnparsedSql(string, (String)object, new DatabaseObject[0]));
        if (createTriggerStatement.getDisabled() != null && createTriggerStatement.getDisabled().booleanValue()) {
            object2 = new DisableTriggerChange();
            ((DisableTriggerChange)((Object)object2)).setCatalogName(createTriggerStatement.getCatalogName());
            ((DisableTriggerChange)((Object)object2)).setSchemaName(createTriggerStatement.getSchemaName());
            ((DisableTriggerChange)((Object)object2)).setTriggerName(createTriggerStatement.getTriggerName());
            ((DisableTriggerChange)((Object)object2)).setTableName(createTriggerStatement.getTableName());
            ((DisableTriggerChange)((Object)object2)).setScope(createTriggerStatement.getScope());
            arrayList.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql(((DisableTriggerChange)((Object)object2)).generateStatements(database), database)));
        }
        CreateProcedureGenerator.surroundWithSchemaSets(arrayList, (String)createTriggerStatement.getSchemaName(), (Database)database);
        ArrayList<Object> arrayList2 = arrayList;
        return arrayList2.toArray(new Sql[arrayList2.size()]);
    }

    private boolean needAppendSchemaName(Database database) {
        return !(database instanceof PostgresDatabase);
    }
}

