/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import liquibase.pro.packaged.oM;
import liquibase.pro.packaged.oP;
import liquibase.pro.packaged.oQ;
import liquibase.pro.packaged.oR;
import liquibase.pro.packaged.oT;
import liquibase.pro.packaged.oV;
import liquibase.pro.packaged.oW;
import liquibase.pro.packaged.oX;
import liquibase.pro.packaged.oY;
import liquibase.pro.packaged.oZ;
import liquibase.pro.packaged.pb;
import liquibase.pro.packaged.pc;

public final class oO<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int NUMBER_OF_READ_BUFFERS = Math.min(4, oO.ceilingNextPowerOfTwo(NCPU));
    static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    static final int READ_BUFFER_THRESHOLD = 4;
    static final int READ_BUFFER_DRAIN_THRESHOLD = 8;
    static final int READ_BUFFER_SIZE = 16;
    static final int READ_BUFFER_INDEX_MASK = 15;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    final ConcurrentMap<K, oW<K, V>> data;
    final int concurrencyLevel;
    final long[] readBufferReadCount;
    final oM<oW<K, V>> evictionDeque;
    final AtomicLong weightedSize;
    final AtomicLong capacity;
    final Lock evictionLock;
    final Queue<Runnable> writeBuffer;
    final AtomicLongArray readBufferWriteCount;
    final AtomicLongArray readBufferDrainAtWriteCount;
    final AtomicReferenceArray<oW<K, V>> readBuffers;
    final AtomicReference<oR> drainStatus;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private static int readBufferIndex(int n2, int n3) {
        return (n2 << 4) + n3;
    }

    private oO(oQ<K, V> oQ2) {
        this.concurrencyLevel = oQ2.concurrencyLevel;
        this.capacity = new AtomicLong(Math.min(oQ2.capacity, 9223372034707292160L));
        this.data = new ConcurrentHashMap<K, oW<K, V>>(oQ2.initialCapacity, 0.75f, this.concurrencyLevel);
        this.evictionLock = new ReentrantLock();
        this.weightedSize = new AtomicLong();
        this.evictionDeque = new oM();
        this.writeBuffer = new ConcurrentLinkedQueue<Runnable>();
        this.drainStatus = new AtomicReference<oR>(oR.IDLE);
        this.readBufferReadCount = new long[NUMBER_OF_READ_BUFFERS];
        this.readBufferWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBufferDrainAtWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBuffers = new AtomicReferenceArray(NUMBER_OF_READ_BUFFERS << 4);
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public final long capacity() {
        return this.capacity.get();
    }

    public final void setCapacity(long l2) {
        oO.checkArgument(l2 >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity.lazySet(Math.min(l2, 9223372034707292160L));
            this.drainBuffers();
            this.evict();
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    final boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity.get();
    }

    final void evict() {
        while (this.hasOverflowed()) {
            oW oW2 = (oW)this.evictionDeque.poll();
            if (oW2 == null) {
                return;
            }
            this.data.remove(oW2.key, oW2);
            this.makeDead(oW2);
        }
    }

    final void afterRead(oW<K, V> oW2) {
        int n2 = oO.readBufferIndex();
        long l2 = this.recordRead(n2, oW2);
        this.drainOnReadIfNeeded(n2, l2);
    }

    static int readBufferIndex() {
        return (int)Thread.currentThread().getId() & READ_BUFFERS_MASK;
    }

    final long recordRead(int n2, oW<K, V> oW2) {
        long l2 = this.readBufferWriteCount.get(n2);
        this.readBufferWriteCount.lazySet(n2, l2 + 1L);
        int n3 = (int)(l2 & 0xFL);
        this.readBuffers.lazySet(oO.readBufferIndex(n2, n3), oW2);
        return l2;
    }

    final void drainOnReadIfNeeded(int n2, long l2) {
        int n3 = n2 = l2 - this.readBufferDrainAtWriteCount.get(n2) < 4L ? 1 : 0;
        if (this.drainStatus.get().shouldDrainBuffers(n2 != 0)) {
            this.tryToDrainBuffers();
        }
    }

    final void afterWrite(Runnable runnable) {
        this.writeBuffer.add(runnable);
        this.drainStatus.lazySet(oR.REQUIRED);
        this.tryToDrainBuffers();
    }

    final void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.lazySet(oR.PROCESSING);
                this.drainBuffers();
                return;
            }
            finally {
                this.drainStatus.compareAndSet(oR.PROCESSING, oR.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    final void drainBuffers() {
        this.drainReadBuffers();
        this.drainWriteBuffer();
    }

    final void drainReadBuffers() {
        int n2;
        int n3 = n2 + NUMBER_OF_READ_BUFFERS;
        for (n2 = (int)Thread.currentThread().getId(); n2 < n3; ++n2) {
            this.drainReadBuffer(n2 & READ_BUFFERS_MASK);
        }
    }

    final void drainReadBuffer(int n2) {
        long l2 = this.readBufferWriteCount.get(n2);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = (int)(this.readBufferReadCount[n2] & 0xFL);
            oW<K, V> oW2 = this.readBuffers.get(n3 = oO.readBufferIndex(n2, n3));
            if (oW2 == null) break;
            this.readBuffers.lazySet(n3, null);
            this.applyRead(oW2);
            int n4 = n2;
            this.readBufferReadCount[n4] = this.readBufferReadCount[n4] + 1L;
        }
        this.readBufferDrainAtWriteCount.lazySet(n2, l2);
    }

    final void applyRead(oW<K, V> oW2) {
        if (this.evictionDeque.contains(oW2)) {
            this.evictionDeque.moveToBack(oW2);
        }
    }

    final void drainWriteBuffer() {
        Runnable runnable;
        for (int i2 = 0; i2 < 16 && (runnable = this.writeBuffer.poll()) != null; ++i2) {
            runnable.run();
        }
    }

    final boolean tryToRetire(oW<K, V> oW2, pc<V> pc2) {
        if (pc2.isAlive()) {
            pc pc3 = new pc(pc2.value, -pc2.weight);
            return oW2.compareAndSet(pc2, pc3);
        }
        return false;
    }

    final void makeRetired(oW<K, V> oW2) {
        pc pc2;
        pc pc3;
        do {
            if ((pc3 = (pc)oW2.get()).isAlive()) continue;
            return;
        } while (!oW2.compareAndSet(pc3, pc2 = new pc(pc3.value, -pc3.weight)));
    }

    final void makeDead(oW<K, V> oW2) {
        pc pc2;
        pc pc3;
        while (!oW2.compareAndSet(pc3 = (pc)oW2.get(), pc2 = new pc(pc3.value, 0))) {
        }
        this.weightedSize.lazySet(this.weightedSize.get() - (long)Math.abs(pc3.weight));
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final void clear() {
        this.evictionLock.lock();
        try {
            Runnable runnable;
            oW oW2;
            while ((oW2 = (oW)this.evictionDeque.poll()) != null) {
                this.data.remove(oW2.key, oW2);
                this.makeDead(oW2);
            }
            for (int i2 = 0; i2 < this.readBuffers.length(); ++i2) {
                this.readBuffers.lazySet(i2, null);
            }
            while ((runnable = this.writeBuffer.poll()) != null) {
                runnable.run();
            }
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public final boolean containsValue(Object object) {
        oO.checkNotNull(object);
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            if (!((oW)iterator.next()).getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final V get(Object object) {
        if ((object = (oW)this.data.get(object)) == null) {
            return null;
        }
        this.afterRead((oW<K, V>)object);
        return ((oW)object).getValue();
    }

    @Override
    public final V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public final V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    final V put(K object, V object2, boolean bl2) {
        pc pc2;
        oW<K, pc> oW2;
        oO.checkNotNull(object);
        oO.checkNotNull(object2);
        object2 = new pc<V>(object2, 1);
        object = new oW(object, object2);
        block0: while (true) {
            if ((oW2 = this.data.putIfAbsent(((oW)object).key, object)) == null) {
                this.afterWrite(new oP(this, (oW)object, 1));
                return null;
            }
            if (bl2) {
                this.afterRead(oW2);
                return oW2.getValue();
            }
            do {
                if (!(pc2 = (pc)oW2.get()).isAlive()) continue block0;
            } while (!oW2.compareAndSet(pc2, (pc)object2));
            break;
        }
        int n2 = 1 - pc2.weight;
        if (n2 == 0) {
            this.afterRead(oW2);
        } else {
            this.afterWrite(new oZ(this, oW2, n2));
        }
        return pc2.value;
    }

    @Override
    public final V remove(Object object) {
        if ((object = (oW)this.data.remove(object)) == null) {
            return null;
        }
        this.makeRetired((oW<K, V>)object);
        this.afterWrite(new oX(this, (oW)object));
        return ((oW)object).getValue();
    }

    @Override
    public final boolean remove(Object object, Object object2) {
        oW oW2 = (oW)this.data.get(object);
        if (oW2 == null || object2 == null) {
            return false;
        }
        pc pc2 = (pc)oW2.get();
        while (pc2.contains(object2)) {
            if (this.tryToRetire(oW2, pc2)) {
                if (!this.data.remove(object, oW2)) break;
                this.afterWrite(new oX(this, oW2));
                return true;
            }
            pc2 = (pc)oW2.get();
            if (pc2.isAlive()) continue;
        }
        return false;
    }

    @Override
    public final V replace(K object, V object2) {
        pc pc2;
        oO.checkNotNull(object);
        oO.checkNotNull(object2);
        object2 = new pc<V>(object2, 1);
        object = (oW)this.data.get(object);
        if (object == null) {
            return null;
        }
        do {
            if ((pc2 = (pc)((AtomicReference)object).get()).isAlive()) continue;
            return null;
        } while (!((AtomicReference)object).compareAndSet(pc2, object2));
        int n2 = 1 - pc2.weight;
        if (n2 == 0) {
            this.afterRead((oW<K, V>)object);
        } else {
            this.afterWrite(new oZ(this, (oW)object, n2));
        }
        return pc2.value;
    }

    @Override
    public final boolean replace(K object, V v2, V object2) {
        pc pc2;
        oO.checkNotNull(object);
        oO.checkNotNull(v2);
        oO.checkNotNull(object2);
        object2 = new pc<V>(object2, 1);
        object = (oW)this.data.get(object);
        if (object == null) {
            return false;
        }
        do {
            if ((pc2 = (pc)((AtomicReference)object).get()).isAlive() && pc2.contains(v2)) continue;
            return false;
        } while (!((AtomicReference)object).compareAndSet(pc2, object2));
        int n2 = 1 - pc2.weight;
        if (n2 == 0) {
            this.afterRead((oW<K, V>)object);
        } else {
            this.afterWrite(new oZ(this, (oW)object, n2));
        }
        return true;
    }

    @Override
    public final Set<K> keySet() {
        Set<K> set = this.keySet;
        if (set == null) {
            this.keySet = new oV(this);
            return this.keySet;
        }
        return set;
    }

    @Override
    public final Collection<V> values() {
        Collection<V> collection = this.values;
        if (collection == null) {
            this.values = new pb(this);
            return this.values;
        }
        return collection;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set == null) {
            this.entrySet = new oT(this);
            return this.entrySet;
        }
        return set;
    }

    final Object writeReplace() {
        return new oY(this);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Proxy required");
    }
}

