/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.KSQLJoinWindow;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class Join
extends ASTNodeAccessImpl {
    private boolean outer = false;
    private boolean right = false;
    private boolean left = false;
    private boolean natural = false;
    private boolean full = false;
    private boolean inner = false;
    private boolean simple = false;
    private boolean cross = false;
    private boolean semi = false;
    private boolean straight = false;
    private boolean apply = false;
    private FromItem rightItem;
    private final LinkedList<Expression> onExpressions = new LinkedList();
    private final LinkedList<Column> usingColumns = new LinkedList();
    private KSQLJoinWindow joinWindow;

    public boolean isSimple() {
        return this.simple;
    }

    public Join withSimple(boolean bl2) {
        this.setSimple(bl2);
        return this;
    }

    public void setSimple(boolean bl2) {
        this.simple = bl2;
    }

    public boolean isInner() {
        return this.inner;
    }

    public Join withInner(boolean bl2) {
        this.setInner(bl2);
        return this;
    }

    public void setInner(boolean bl2) {
        this.inner = bl2;
    }

    public boolean isStraight() {
        return this.straight;
    }

    public Join withStraight(boolean bl2) {
        this.setStraight(bl2);
        return this;
    }

    public void setStraight(boolean bl2) {
        this.straight = bl2;
    }

    public boolean isOuter() {
        return this.outer;
    }

    public Join withOuter(boolean bl2) {
        this.setOuter(bl2);
        return this;
    }

    public void setOuter(boolean bl2) {
        this.outer = bl2;
    }

    public boolean isApply() {
        return this.apply;
    }

    public Join withApply(boolean bl2) {
        this.setApply(bl2);
        return this;
    }

    public void setApply(boolean bl2) {
        this.apply = bl2;
    }

    public boolean isSemi() {
        return this.semi;
    }

    public Join withSemi(boolean bl2) {
        this.setSemi(bl2);
        return this;
    }

    public void setSemi(boolean bl2) {
        this.semi = bl2;
    }

    public boolean isLeft() {
        return this.left;
    }

    public Join withLeft(boolean bl2) {
        this.setLeft(bl2);
        return this;
    }

    public void setLeft(boolean bl2) {
        this.left = bl2;
    }

    public boolean isRight() {
        return this.right;
    }

    public Join withRight(boolean bl2) {
        this.setRight(bl2);
        return this;
    }

    public void setRight(boolean bl2) {
        this.right = bl2;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public Join withNatural(boolean bl2) {
        this.setNatural(bl2);
        return this;
    }

    public void setNatural(boolean bl2) {
        this.natural = bl2;
    }

    public boolean isFull() {
        return this.full;
    }

    public Join withFull(boolean bl2) {
        this.setFull(bl2);
        return this;
    }

    public void setFull(boolean bl2) {
        this.full = bl2;
    }

    public boolean isCross() {
        return this.cross;
    }

    public Join withCross(boolean bl2) {
        this.setCross(bl2);
        return this;
    }

    public void setCross(boolean bl2) {
        this.cross = bl2;
    }

    public FromItem getRightItem() {
        return this.rightItem;
    }

    public Join withRightItem(FromItem fromItem) {
        this.setRightItem(fromItem);
        return this;
    }

    public void setRightItem(FromItem fromItem) {
        this.rightItem = fromItem;
    }

    @Deprecated
    public Expression getOnExpression() {
        return this.onExpressions.get(0);
    }

    public Collection<Expression> getOnExpressions() {
        return this.onExpressions;
    }

    @Deprecated
    public Join withOnExpression(Expression expression) {
        this.setOnExpression(expression);
        return this;
    }

    @Deprecated
    public void setOnExpression(Expression expression) {
        this.onExpressions.add(0, expression);
    }

    public Join addOnExpression(Expression expression) {
        this.onExpressions.add(expression);
        return this;
    }

    public Join setOnExpressions(Collection<Expression> collection) {
        this.onExpressions.clear();
        this.onExpressions.addAll(collection);
        return this;
    }

    public List<Column> getUsingColumns() {
        return this.usingColumns;
    }

    public Join withUsingColumns(List<Column> list) {
        this.setUsingColumns(list);
        return this;
    }

    public void setUsingColumns(List<Column> list) {
        this.usingColumns.clear();
        this.usingColumns.addAll(list);
    }

    public boolean isWindowJoin() {
        return this.joinWindow != null;
    }

    public KSQLJoinWindow getJoinWindow() {
        return this.joinWindow;
    }

    public Join withJoinWindow(KSQLJoinWindow kSQLJoinWindow) {
        this.setJoinWindow(kSQLJoinWindow);
        return this;
    }

    public void setJoinWindow(KSQLJoinWindow kSQLJoinWindow) {
        this.joinWindow = kSQLJoinWindow;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isSimple() && this.isOuter()) {
            stringBuilder.append("OUTER ").append(this.rightItem);
        } else if (this.isSimple()) {
            stringBuilder.append(this.rightItem);
        } else {
            if (this.isNatural()) {
                stringBuilder.append("NATURAL ");
            }
            if (this.isRight()) {
                stringBuilder.append("RIGHT ");
            } else if (this.isFull()) {
                stringBuilder.append("FULL ");
            } else if (this.isLeft()) {
                stringBuilder.append("LEFT ");
            } else if (this.isCross()) {
                stringBuilder.append("CROSS ");
            }
            if (this.isOuter()) {
                stringBuilder.append("OUTER ");
            } else if (this.isInner()) {
                stringBuilder.append("INNER ");
            } else if (this.isSemi()) {
                stringBuilder.append("SEMI ");
            }
            if (this.isStraight()) {
                stringBuilder.append("STRAIGHT_JOIN ");
            } else if (this.isApply()) {
                stringBuilder.append("APPLY ");
            } else {
                stringBuilder.append("JOIN ");
            }
            stringBuilder.append(this.rightItem).append(this.joinWindow != null ? " WITHIN " + this.joinWindow : "");
        }
        for (Expression expression : this.onExpressions) {
            stringBuilder.append(" ON ").append(expression);
        }
        if (this.usingColumns.size() > 0) {
            stringBuilder.append(PlainSelect.getFormatedList(this.usingColumns, "USING", true, true));
        }
        return stringBuilder.toString();
    }

    public Join addUsingColumns(Column ... columnArray) {
        List list = Optional.ofNullable(this.getUsingColumns()).orElseGet(ArrayList::new);
        Collections.addAll(list, columnArray);
        return this.withUsingColumns(list);
    }

    public Join addUsingColumns(Collection<? extends Column> collection) {
        List list = Optional.ofNullable(this.getUsingColumns()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withUsingColumns(list);
    }
}

