/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.introspection;

import java.util.List;
import java.util.Set;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.extension.introspection.declaration.OperationExecutorFactory;
import org.mule.extension.runtime.OperationExecutor;
import org.mule.module.extension.internal.introspection.AbstractImmutableCapableDescribed;
import org.mule.module.extension.internal.util.MuleExtensionUtils;
import org.mule.util.Preconditions;

final class ImmutableOperation
extends AbstractImmutableCapableDescribed
implements Operation {
    private final List<Parameter> parameters;
    private final OperationExecutorFactory executorFactory;

    ImmutableOperation(String name, String description, OperationExecutorFactory executorFactory, List<Parameter> parameters, Set<Object> capabilities) {
        super(name, description, capabilities);
        Preconditions.checkArgument((executorFactory != null ? 1 : 0) != 0, (String)String.format("Operation %s cannot have a null executor factory", name));
        this.executorFactory = executorFactory;
        this.parameters = MuleExtensionUtils.immutableList(parameters);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public <T> OperationExecutor getExecutor(T configurationInstance) {
        return this.executorFactory.getExecutor(configurationInstance);
    }
}

