/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.runtime;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleEvent;
import org.mule.extension.introspection.Extension;
import org.mule.extension.introspection.Operation;
import org.mule.extension.introspection.Parameter;
import org.mule.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.module.extension.internal.runtime.OperationContextAdapter;
import org.mule.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.util.StringUtils;

public class DefaultOperationContext
implements OperationContextAdapter {
    private final String configurationInstanceProviderName;
    private final Extension extension;
    private final Operation operation;
    private final Map<String, Object> parameters;
    private final MuleEvent event;
    private final ExtensionManagerAdapter extensionManager;
    private Object configurationInstance;

    public DefaultOperationContext(Extension extension, Operation operation, String configurationInstanceProviderName, ResolverSetResult parameters, MuleEvent event, ExtensionManagerAdapter extensionManager) {
        this.extension = extension;
        this.operation = operation;
        this.configurationInstanceProviderName = configurationInstanceProviderName;
        this.event = event;
        this.extensionManager = extensionManager;
        Map<Parameter, Object> parameterMap = parameters.asMap();
        this.parameters = new HashMap<String, Object>(parameterMap.size());
        for (Map.Entry<Parameter, Object> parameter : parameterMap.entrySet()) {
            this.parameters.put(parameter.getKey().getName(), parameter.getValue());
        }
    }

    public <C> C getConfigurationInstance() {
        if (this.configurationInstance == null) {
            this.configurationInstance = StringUtils.isBlank((String)this.configurationInstanceProviderName) ? this.extensionManager.getConfigurationInstance(this.extension, this) : this.extensionManager.getConfigurationInstance(this.extension, this.configurationInstanceProviderName, this);
        }
        return (C)this.configurationInstance;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Object getParameterValue(String parameterName) {
        return this.parameters.get(parameterName);
    }

    @Override
    public MuleEvent getEvent() {
        return this.event;
    }
}

