/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.functional;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;

public class InvocationCountMessageProcessor
implements MessageProcessor,
Initialisable {
    private static Map<String, AtomicInteger> invocationCountPerMessageProcessor = new HashMap<String, AtomicInteger>();
    private final AtomicInteger invocationCount = new AtomicInteger();
    private String name;

    public MuleEvent process(MuleEvent event) throws MuleException {
        this.invocationCount.incrementAndGet();
        return event;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void initialise() throws InitialisationException {
        this.invocationCount.set(0);
        invocationCountPerMessageProcessor.put(this.name, this.invocationCount);
    }

    public static int getNumberOfInvocationsFor(String componentName) {
        AtomicInteger count = invocationCountPerMessageProcessor.get(componentName);
        if (count == null) {
            throw new IllegalArgumentException("No invocation-counter component registered under name: " + componentName + " + registered components: " + invocationCountPerMessageProcessor.keySet());
        }
        return count.get();
    }
}

