/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.number;

import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.changes.MapHelper;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.number.DataStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencyStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencySymbolElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMapElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfNumberCurrencyStyle
extends NumberCurrencyStyleElement {
    public OdfNumberCurrencyStyle(OdfFileDom ownerDoc) {
        super(ownerDoc);
    }

    public OdfNumberCurrencyStyle(OdfFileDom ownerDoc, String currencySymbol, String format, String styleName) {
        super(ownerDoc);
        this.setStyleNameAttribute(styleName);
        this.buildFromFormat(currencySymbol, format);
    }

    public OdfNumberCurrencyStyle(OdfFileDom ownerDoc, String format, String styleName) {
        super(ownerDoc);
        this.setStyleNameAttribute(styleName);
        this.setFormat(format);
    }

    @Override
    public String getFormat(boolean caps) {
        Object result = "";
        Object mappedResult = "";
        for (Node m = this.getFirstChild(); m != null; m = m.getNextSibling()) {
            if (m instanceof NumberCurrencySymbolElement) {
                result = (String)result + "[$";
                result = (String)result + m.getTextContent();
                String language = ((NumberCurrencySymbolElement)((Object)m)).getAttributeNS(OdfDocumentNamespace.NUMBER.getUri(), "language");
                String country = ((NumberCurrencySymbolElement)((Object)m)).getAttributeNS(OdfDocumentNamespace.NUMBER.getUri(), "country");
                if (!language.isEmpty()) {
                    result = (String)result + "-";
                    result = (String)result + MapHelper.getMSLangCode(language, country);
                }
                result = (String)result + "]";
                continue;
            }
            if (m instanceof NumberNumberElement) {
                result = (String)result + this.getNumberFormat();
                continue;
            }
            if (m instanceof NumberTextElement) {
                String textcontent = m.getTextContent();
                if (textcontent == null || textcontent.length() == 0) {
                    textcontent = " ";
                }
                result = (String)result + textcontent;
                continue;
            }
            if (m instanceof StyleTextPropertiesElement) {
                result = (String)result + this.getColorFromElement((StyleTextPropertiesElement)((Object)m));
                continue;
            }
            if (!(m instanceof StyleMapElement)) continue;
            mappedResult = (String)mappedResult + this.getMapping((StyleMapElement)((Object)m));
            mappedResult = (String)mappedResult + ";";
        }
        if (!((String)mappedResult).isEmpty()) {
            result = (String)mappedResult + (String)result;
        }
        return result;
    }

    public String getCurrencyCode() {
        for (Node m = this.getFirstChild(); m != null; m = m.getNextSibling()) {
            if (!(m instanceof NumberCurrencySymbolElement)) continue;
            String currencyValue = m.getTextContent();
            if (currencyValue != null && currencyValue.equals("DM")) {
                return "DEM";
            }
            String language = ((NumberCurrencySymbolElement)((Object)m)).getAttributeNS(OdfDocumentNamespace.NUMBER.getUri(), "language");
            String country = ((NumberCurrencySymbolElement)((Object)m)).getAttributeNS(OdfDocumentNamespace.NUMBER.getUri(), "country");
            if (language == null) break;
            try {
                Currency currency = Currency.getInstance(country != null ? new Locale(language, country) : new Locale(language));
                if (currency != null) {
                    return currency.toString();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            break;
        }
        return this.getCurrencySymbolElement().getTextContent();
    }

    public String getConditionStyleName(double value) {
        StyleMapElement map = OdfElement.findFirstChildNode(StyleMapElement.class, (Node)((Object)this));
        while (map != null) {
            String condition = map.getStyleConditionAttribute();
            if (this.isTrue(condition, value)) {
                return map.getStyleApplyStyleNameAttribute();
            }
            map = OdfElement.findNextChildNode(StyleMapElement.class, (Node)((Object)map));
        }
        return this.getStyleNameAttribute();
    }

    private boolean isTrue(String condition, double value) {
        double rightOp = this.getLastNumber(condition);
        if (condition.indexOf(62) != -1 ? value > rightOp : condition.indexOf(60) != -1 && value < rightOp) {
            return true;
        }
        return condition.indexOf(33) != -1 ? value != rightOp : condition.indexOf(61) != -1 && value == rightOp;
    }

    private Double getLastNumber(String condition) {
        Object results = "";
        for (int i = condition.length() - 1; i >= 0 && condition.charAt(i) >= '0' && condition.charAt(i) <= '9'; --i) {
            results = (String)results + condition.charAt(i);
        }
        return Double.parseDouble((String)results);
    }

    @Override
    public void setFormat(String format) {
        OdfFileDom dom = (OdfFileDom)((Object)this.getOwnerDocument());
        List<DataStyleElement.StringToken> tokens = OdfNumberCurrencyStyle.tokenize(format, DataStyleElement.NumberFormatType.FORMAT_CURRENCY);
        this.emitTokens(tokens, DataStyleElement.NumberFormatType.FORMAT_CURRENCY);
    }

    public void buildFromFormat(String currencySymbol, String format) {
        Pattern p = Pattern.compile("[#0,.]+");
        Matcher m = p.matcher(format);
        if (m.find()) {
            char ch;
            int pos;
            String preMatch = format.substring(0, m.start());
            String numberSpec = format.substring(m.start(), m.end());
            String postMatch = format.substring(m.end());
            this.processText(preMatch, currencySymbol);
            NumberNumberElement number = new NumberNumberElement((OdfFileDom)((Object)this.getOwnerDocument()));
            int nDigits = 0;
            for (pos = 0; pos < numberSpec.length() && (ch = numberSpec.charAt(pos)) != '.'; ++pos) {
                if (ch == ',') {
                    number.setNumberGroupingAttribute(true);
                    continue;
                }
                if (ch != '0') continue;
                ++nDigits;
            }
            number.setNumberMinIntegerDigitsAttribute(nDigits);
            if (pos < numberSpec.length()) {
                number.setNumberDecimalPlacesAttribute(numberSpec.length() - (pos + 1));
            }
            this.appendChild((Node)((Object)number));
            this.processText(postMatch, currencySymbol);
        }
    }

    private void processText(String text, String currencySymbol) {
        OdfFileDom dom = (OdfFileDom)((Object)this.getOwnerDocument());
        int currencyPos = text.indexOf(currencySymbol);
        if (currencyPos >= 0) {
            this.emitText(text.substring(0, currencyPos));
            NumberCurrencySymbolElement cSymbol = new NumberCurrencySymbolElement(dom);
            cSymbol.appendChild(dom.createTextNode(currencySymbol));
            this.appendChild((Node)((Object)cSymbol));
            this.emitText(text.substring(currencyPos + currencySymbol.length()));
        } else {
            this.emitText(text);
        }
    }

    public NumberCurrencySymbolElement getCurrencySymbolElement() {
        NumberCurrencySymbolElement cSymbol = null;
        NodeList list = this.getElementsByTagNameNS(OdfDocumentNamespace.NUMBER.getUri(), "currency-symbol");
        if (list.getLength() > 0) {
            cSymbol = (NumberCurrencySymbolElement)((Object)list.item(0));
        }
        return cSymbol;
    }

    public void setCurrencyLocale(String language, String country) {
        NumberCurrencySymbolElement cSymbol = this.getCurrencySymbolElement();
        cSymbol.setNumberCountryAttribute(country);
        cSymbol.setNumberLanguageAttribute(language);
    }

    public void setCurrencyLocale(String locale) {
        NumberCurrencySymbolElement cSymbol = this.getCurrencySymbolElement();
        int pos = locale.indexOf(45);
        if (pos >= 0) {
            cSymbol.setNumberLanguageAttribute(locale.substring(0, pos));
            cSymbol.setNumberCountryAttribute(locale.substring(pos + 1));
        } else {
            cSymbol.setNumberLanguageAttribute(locale);
        }
    }

    public void setMapPositive(String mapName) {
        StyleMapElement map = new StyleMapElement((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()>0");
        this.appendChild((Node)((Object)map));
    }

    public void setMapNegative(String mapName) {
        StyleMapElement map = new StyleMapElement((OdfFileDom)((Object)this.getOwnerDocument()));
        map.setStyleApplyStyleNameAttribute(mapName);
        map.setStyleConditionAttribute("value()<0");
        this.appendChild((Node)((Object)map));
    }
}

