/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.protobuf.internal;

import java.util.List;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.protobuf.ProtoVisitor;
import org.openrewrite.protobuf.tree.Comment;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.protobuf.tree.ProtoContainer;
import org.openrewrite.protobuf.tree.ProtoLeftPadded;
import org.openrewrite.protobuf.tree.ProtoRightPadded;
import org.openrewrite.protobuf.tree.Space;

public class ProtoPrinter<P>
extends ProtoVisitor<PrintOutputCapture<P>> {
    @Override
    public Proto visitBlock(Proto.Block block, PrintOutputCapture<P> p) {
        this.visitSpace(block.getPrefix(), p);
        this.visitMarkers(block.getMarkers(), p);
        p.out.append('{');
        this.visitStatements(block.getPadding().getStatements(), p);
        this.visitSpace(block.getEnd(), p);
        p.out.append('}');
        return block;
    }

    @Override
    public Proto visitConstant(Proto.Constant constant, PrintOutputCapture<P> p) {
        this.visitSpace(constant.getPrefix(), p);
        this.visitMarkers(constant.getMarkers(), p);
        p.out.append(constant.getValueSource());
        return constant;
    }

    @Override
    public Proto visitDocument(Proto.Document document, PrintOutputCapture<P> p) {
        this.visitSpace(document.getPrefix(), p);
        this.visitMarkers(document.getMarkers(), p);
        this.visit(document.getSyntax(), p);
        this.visitStatements(document.getPadding().getBody(), p);
        this.visitSpace(document.getEof(), p);
        return document;
    }

    @Override
    public Proto visitEmpty(Proto.Empty empty, PrintOutputCapture<P> p) {
        this.visitSpace(empty.getPrefix(), p);
        this.visitMarkers(empty.getMarkers(), p);
        return empty;
    }

    @Override
    public Proto visitEnum(Proto.Enum anEnum, PrintOutputCapture<P> p) {
        this.visitSpace(anEnum.getPrefix(), p);
        this.visitMarkers(anEnum.getMarkers(), p);
        p.out.append("enum");
        this.visit(anEnum.getName(), p);
        this.visit(anEnum.getBody(), p);
        return anEnum;
    }

    @Override
    public Proto visitEnumField(Proto.EnumField enumField, PrintOutputCapture<P> p) {
        this.visitSpace(enumField.getPrefix(), p);
        this.visitMarkers(enumField.getMarkers(), p);
        this.visitRightPadded(enumField.getPadding().getName(), p);
        p.out.append('=');
        this.visit(enumField.getNumber(), p);
        this.visitContainer("[", enumField.getPadding().getOptions(), ",", "]", p);
        return enumField;
    }

    @Override
    public Proto visitExtend(Proto.Extend extend, PrintOutputCapture<P> p) {
        this.visitSpace(extend.getPrefix(), p);
        this.visitMarkers(extend.getMarkers(), p);
        p.out.append("extend");
        this.visitFullIdentifier(extend.getName(), p);
        this.visitBlock(extend.getBody(), p);
        return extend;
    }

    @Override
    public Proto visitExtensionName(Proto.ExtensionName extensionName, PrintOutputCapture<P> p) {
        this.visitSpace(extensionName.getPrefix(), p);
        this.visitMarkers(extensionName.getMarkers(), p);
        p.out.append('(');
        this.visitRightPadded(extensionName.getPadding().getExtension(), p);
        p.out.append(')');
        return extensionName;
    }

    @Override
    public Proto visitField(Proto.Field field, PrintOutputCapture<P> p) {
        this.visitSpace(field.getPrefix(), p);
        this.visitMarkers(field.getMarkers(), p);
        this.visit(field.getLabel(), p);
        this.visit(field.getType(), p);
        this.visitRightPadded(field.getPadding().getName(), p);
        p.out.append('=');
        this.visit(field.getNumber(), p);
        this.visitContainer("[", field.getPadding().getOptions(), ",", "]", p);
        return field;
    }

    @Override
    public Proto visitFullIdentifier(Proto.FullIdentifier identifier, PrintOutputCapture<P> p) {
        this.visitSpace(identifier.getPrefix(), p);
        this.visitMarkers(identifier.getMarkers(), p);
        this.visitRightPadded(identifier.getPadding().getTarget(), p);
        if (identifier.getTarget() != null) {
            p.out.append('.');
        }
        this.visit(identifier.getName(), p);
        return identifier;
    }

    @Override
    public Proto visitIdentifier(Proto.Identifier identifier, PrintOutputCapture<P> p) {
        this.visitSpace(identifier.getPrefix(), p);
        this.visitMarkers(identifier.getMarkers(), p);
        p.out.append(identifier.getName());
        return identifier;
    }

    @Override
    public Proto visitImport(Proto.Import anImport, PrintOutputCapture<P> p) {
        this.visitSpace(anImport.getPrefix(), p);
        this.visitMarkers(anImport.getMarkers(), p);
        p.out.append("import");
        this.visit(anImport.getModifier(), p);
        this.visitRightPadded(anImport.getPadding().getName(), p);
        return anImport;
    }

    @Override
    public Proto visitKeyword(Proto.Keyword keyword, PrintOutputCapture<P> p) {
        this.visitSpace(keyword.getPrefix(), p);
        this.visitMarkers(keyword.getMarkers(), p);
        p.out.append(keyword.getKeyword());
        return keyword;
    }

    @Override
    public Proto visitMapField(Proto.MapField mapField, PrintOutputCapture<P> p) {
        this.visitSpace(mapField.getPrefix(), p);
        this.visitMarkers(mapField.getMarkers(), p);
        p.out.append("map");
        this.visitSpace(mapField.getPadding().getMap().getAfter(), p);
        p.out.append('<');
        this.visitRightPadded(mapField.getPadding().getKeyType(), p);
        p.out.append(',');
        this.visitRightPadded(mapField.getPadding().getValueType(), p);
        p.out.append('>');
        this.visitRightPadded(mapField.getPadding().getName(), p);
        p.out.append('=');
        this.visit(mapField.getNumber(), p);
        this.visitContainer("[", mapField.getPadding().getOptions(), ",", "]", p);
        return mapField;
    }

    @Override
    public Proto visitMessage(Proto.Message message, PrintOutputCapture<P> p) {
        this.visitSpace(message.getPrefix(), p);
        this.visitMarkers(message.getMarkers(), p);
        p.out.append("message");
        this.visit(message.getName(), p);
        this.visit(message.getBody(), p);
        return message;
    }

    @Override
    public Proto visitOneOf(Proto.OneOf oneOf, PrintOutputCapture<P> p) {
        this.visitSpace(oneOf.getPrefix(), p);
        this.visitMarkers(oneOf.getMarkers(), p);
        p.out.append("oneof");
        this.visit(oneOf.getName(), p);
        this.visit(oneOf.getFields(), p);
        return oneOf;
    }

    @Override
    public Proto visitOption(Proto.Option option, PrintOutputCapture<P> p) {
        this.visitSpace(option.getPrefix(), p);
        this.visitMarkers(option.getMarkers(), p);
        this.visitRightPadded(option.getPadding().getName(), p);
        p.out.append('=');
        this.visit(option.getAssignment(), p);
        return option;
    }

    @Override
    public Proto visitOptionDeclaration(Proto.OptionDeclaration optionDeclaration, PrintOutputCapture<P> p) {
        this.visitSpace(optionDeclaration.getPrefix(), p);
        this.visitMarkers(optionDeclaration.getMarkers(), p);
        p.out.append("option");
        this.visitRightPadded(optionDeclaration.getPadding().getName(), p);
        p.out.append('=');
        this.visit(optionDeclaration.getAssignment(), p);
        return optionDeclaration;
    }

    @Override
    public Proto visitPackage(Proto.Package aPackage, PrintOutputCapture<P> p) {
        this.visitSpace(aPackage.getPrefix(), p);
        this.visitMarkers(aPackage.getMarkers(), p);
        p.out.append("package");
        this.visit(aPackage.getName(), p);
        return aPackage;
    }

    @Override
    public Proto visitPrimitive(Proto.Primitive primitive, PrintOutputCapture<P> p) {
        this.visitSpace(primitive.getPrefix(), p);
        this.visitMarkers(primitive.getMarkers(), p);
        p.out.append(primitive.getType().toString().toLowerCase());
        return primitive;
    }

    @Override
    public Proto visitRange(Proto.Range range, PrintOutputCapture<P> p) {
        this.visitSpace(range.getPrefix(), p);
        this.visitMarkers(range.getMarkers(), p);
        this.visitRightPadded(range.getPadding().getFrom(), p);
        if (range.getTo() != null) {
            p.out.append("to");
            this.visit(range.getTo(), p);
        }
        return range;
    }

    @Override
    public Proto visitReserved(Proto.Reserved reserved, PrintOutputCapture<P> p) {
        this.visitSpace(reserved.getPrefix(), p);
        this.visitMarkers(reserved.getMarkers(), p);
        p.out.append("reserved");
        this.visitContainer("", reserved.getPadding().getReservations(), ",", "", p);
        return reserved;
    }

    @Override
    public Proto visitRpc(Proto.Rpc rpc, PrintOutputCapture<P> p) {
        this.visitSpace(rpc.getPrefix(), p);
        this.visitMarkers(rpc.getMarkers(), p);
        p.out.append("rpc");
        this.visit(rpc.getName(), p);
        this.visit(rpc.getRequest(), p);
        this.visit(rpc.getReturns(), p);
        this.visit(rpc.getResponse(), p);
        this.visit(rpc.getBody(), p);
        return rpc;
    }

    @Override
    public Proto visitRpcInOut(Proto.RpcInOut rpcInOut, PrintOutputCapture<P> p) {
        this.visitSpace(rpcInOut.getPrefix(), p);
        this.visitMarkers(rpcInOut.getMarkers(), p);
        p.out.append('(');
        if (rpcInOut.getStream() != null) {
            this.visitSpace(rpcInOut.getStream().getPrefix(), p);
            p.out.append("stream");
        }
        this.visitRightPadded(rpcInOut.getPadding().getType(), p);
        p.out.append(')');
        return rpcInOut;
    }

    @Override
    public Proto visitService(Proto.Service service, PrintOutputCapture<P> p) {
        this.visitSpace(service.getPrefix(), p);
        this.visitMarkers(service.getMarkers(), p);
        p.out.append("service");
        this.visit(service.getName(), p);
        this.visit(service.getBody(), p);
        return service;
    }

    @Override
    public Proto visitStringLiteral(Proto.StringLiteral stringLiteral, PrintOutputCapture<P> p) {
        this.visitSpace(stringLiteral.getPrefix(), p);
        this.visitMarkers(stringLiteral.getMarkers(), p);
        p.out.append(stringLiteral.isSingleQuote() ? (char)'\'' : '\"');
        p.out.append(stringLiteral.getLiteral());
        p.out.append(stringLiteral.isSingleQuote() ? (char)'\'' : '\"');
        return stringLiteral;
    }

    @Override
    public Proto visitSyntax(Proto.Syntax syntax, PrintOutputCapture<P> p) {
        this.visitSpace(syntax.getPrefix(), p);
        this.visitMarkers(syntax.getMarkers(), p);
        p.out.append("syntax");
        this.visitSpace(syntax.getKeywordSuffix(), p);
        p.out.append('=');
        this.visitRightPadded(syntax.getPadding().getLevel(), p);
        p.out.append(';');
        return syntax;
    }

    @Override
    public Space visitSpace(Space space, PrintOutputCapture<P> p) {
        p.out.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            if (comment.isMultiline()) {
                p.out.append("/*").append(comment.getText()).append("*/");
            } else {
                p.out.append("//").append(comment.getText());
            }
            p.out.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitContainer(String before, @Nullable ProtoContainer<? extends Proto> container, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), suffixBetween, p);
        p.append(after == null ? "" : after);
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable ProtoLeftPadded<? extends Proto> leftPadded, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.visitSpace(leftPadded.getBefore(), p);
            if (prefix != null) {
                p.out.append(prefix);
            }
            this.visit(leftPadded.getElement(), p);
        }
    }

    protected void visitRightPadded(List<? extends ProtoRightPadded<? extends Proto>> nodes, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            ProtoRightPadded<? extends Proto> node = nodes.get(i);
            this.visit(node.getElement(), p);
            this.visitSpace(node.getAfter(), p);
            if (i >= nodes.size() - 1) continue;
            p.out.append(suffixBetween);
        }
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        if (marker instanceof SearchResult) {
            String description = ((SearchResult)marker).getDescription();
            p.out.append("/*~~").append(description == null ? "" : "(" + description + ")~~").append(">*/");
        }
        return (M)marker;
    }

    protected void visitStatements(List<ProtoRightPadded<Proto>> statements, PrintOutputCapture<P> p) {
        for (ProtoRightPadded<Proto> paddedStat : statements) {
            this.visitStatement(paddedStat, p);
        }
    }

    protected void visitStatement(@Nullable ProtoRightPadded<Proto> paddedStat, PrintOutputCapture<P> p) {
        if (paddedStat == null) {
            return;
        }
        this.visit(paddedStat.getElement(), p);
        this.visitSpace(paddedStat.getAfter(), p);
        Proto s = paddedStat.getElement();
        if (s instanceof Proto.Empty || s instanceof Proto.Field || s instanceof Proto.Import || s instanceof Proto.MapField || s instanceof Proto.EnumField || s instanceof Proto.OptionDeclaration || s instanceof Proto.Package || s instanceof Proto.Reserved || s instanceof Proto.Rpc && ((Proto.Rpc)s).getBody() == null || s instanceof Proto.Syntax) {
            p.append(';');
        }
    }
}

