/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: HeuristicMixedException.java 1506 2007-06-30 15:34:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;
 
/**
 * This exception is thrown to report that a heuristic decision was made
 * and that some relevant updates have been committed and others have
 * been rolled back.
 * @author Guillaume Sauthier
 */
public class HeuristicMixedException extends Exception {

    /**
     * Serial Version UID.
     * TODO Check for interop
     */
    private static final long serialVersionUID = 2345014349685956666L;

    /**
     * Creates a new HeuristicMixedException.
     */
    public HeuristicMixedException() {
    }

    /**
     * Creates a new HeuristicMixedException.
     * @param msg Exception message
     */
    public HeuristicMixedException(String msg) {
        super(msg);
    }

}
