/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: InvalidTransactionException.java 1506 2007-06-30 15:34:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;

import java.rmi.RemoteException;
 
/**
 * This exception indicates that the request carried an invalid
 * transaction context. For example, this exception could be
 * raised if an error occurred when trying to register a resource.
 * @author Guillaume Sauthier
 */
public class InvalidTransactionException extends RemoteException {

    /**
     * Serial Version UID.
     * TODO Check for interop
     */
    private static final long serialVersionUID = 3597320220337691496L;

    /**
     * Creates a new InvalidTransactionException.
     */
    public InvalidTransactionException() {
        super();
    }

    /**
     * Creates a new InvalidTransactionException.
     * @param msg
     */
    public InvalidTransactionException(String msg) {
        super(msg);
    }


}
