/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SystemException.java 1506 2007-06-30 15:34:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;
 
/**
 * The SystemException is thrown by the transaction manager to
 * indicate that it has encountered an unexpected error condition
 * that prevents future transaction services from proceeding.
 * @author Guillaume Sauthier
 */
public class SystemException extends Exception {

    /**
     * Serial Version UID.
     * TODO Check for interop
     */
    private static final long serialVersionUID = 839699079412719325L;
    
    /**
     * The error code with which to create the SystemException.
     */
    public int errorCode;

    /**
     * Create an SystemException.
     */
    public SystemException() {
        // TODO What is the default errorCode value ?
    }

    /**
     * Create an SystemException with a given error code.
     * @param errcode The error code for the exception
     */
    public SystemException(int errcode) {
        super();
        this.errorCode = errcode;
    }

    /**
     * Create an SystemException with a given string.
     * @param s The {@link String} object containing the exception message.
     */
    public SystemException(String s) {
        super(s);
    }
}
