/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import org.pitest.classinfo.ClassInfo;
import org.pitest.coverage.ClassLine;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalIterable;
import org.pitest.functional.FunctionalList;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.report.html.Line;
import org.pitest.mutationtest.report.html.LineStatus;
import org.pitest.util.InputStreamLineIterable;
import org.pitest.util.StringUtil;

public class AnnotatedLineFactory {
    private final FunctionalIterable<MutationResult> mutations;
    private final CoverageDatabase statistics;
    private final Collection<ClassInfo> classesInFile;

    public AnnotatedLineFactory(FunctionalIterable<MutationResult> mutations, CoverageDatabase statistics, Collection<ClassInfo> classes) {
        this.mutations = mutations;
        this.statistics = statistics;
        this.classesInFile = classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionalList<Line> convert(Reader source) throws IOException {
        try {
            InputStreamLineIterable lines = new InputStreamLineIterable(source);
            FunctionalList functionalList = lines.map(this.stringToAnnotatedLine());
            return functionalList;
        }
        finally {
            source.close();
        }
    }

    private F<String, Line> stringToAnnotatedLine() {
        return new F<String, Line>(){
            private int lineNumber = 1;

            public Line apply(String a) {
                Line l = new Line(this.lineNumber, StringUtil.escapeBasicHtmlChars((String)a), AnnotatedLineFactory.this.lineCovered(this.lineNumber), AnnotatedLineFactory.this.getMutationsForLine(this.lineNumber));
                ++this.lineNumber;
                return l;
            }
        };
    }

    private List<MutationResult> getMutationsForLine(int lineNumber) {
        return this.mutations.filter(this.isAtLineNumber(lineNumber));
    }

    private F<MutationResult, Boolean> isAtLineNumber(final int lineNumber) {
        return new F<MutationResult, Boolean>(){

            public Boolean apply(MutationResult result) {
                return result.getDetails().getLineNumber() == lineNumber;
            }
        };
    }

    private LineStatus lineCovered(int line) {
        if (!this.isCodeLine(line)) {
            return LineStatus.NotApplicable;
        }
        if (this.isLineCovered(line)) {
            return LineStatus.Covered;
        }
        return LineStatus.NotCovered;
    }

    private boolean isCodeLine(final int line) {
        F<ClassInfo, Boolean> predicate = new F<ClassInfo, Boolean>(){

            public Boolean apply(ClassInfo a) {
                return a.isCodeLine(line);
            }
        };
        return FCollection.contains(this.classesInFile, (F)predicate);
    }

    private boolean isLineCovered(final int line) {
        F<ClassInfo, Boolean> predicate = new F<ClassInfo, Boolean>(){

            public Boolean apply(ClassInfo a) {
                return !AnnotatedLineFactory.this.statistics.getTestsForClassLine(new ClassLine(a.getName().asInternalName(), line)).isEmpty();
            }
        };
        return FCollection.contains(this.classesInFile, (F)predicate);
    }
}

