/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.mockcreation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.creation.instance.InstantiatorProvider;
import org.mockito.internal.handler.MockHandlerFactory;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.reflection.LenientCopyTool;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.powermock.api.mockito.internal.invocation.MockitoMethodInvocationControl;
import org.powermock.api.mockito.internal.mockcreation.AbstractMockCreator;
import org.powermock.api.mockito.internal.mockcreation.MockitoStateCleaner;
import org.powermock.api.mockito.internal.mockcreation.PowerMockMethodInterceptorFilter;
import org.powermock.api.mockito.repackaged.ClassImposterizer;
import org.powermock.api.mockito.repackaged.MethodInterceptorFilter;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.DefaultFieldValueGenerator;
import org.powermock.core.MockRepository;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.reflect.Whitebox;

public class MockCreator
extends AbstractMockCreator {
    private static final MockCreator MOCK_CREATOR = new MockCreator();

    public static <T> T mock(Class<T> type, boolean isStatic, boolean isSpy, Object delegator, MockSettings mockSettings, Method ... methods) {
        return MOCK_CREATOR.createMock(type, isStatic, isSpy, delegator, mockSettings, methods);
    }

    protected <T> T createMock(Class<T> type, boolean isStatic, boolean isSpy, Object delegator, MockSettings mockSettings, Method ... methods) {
        if (type == null) {
            throw new IllegalArgumentException("The class to mock cannot be null");
        }
        this.validateType(type, isStatic, isSpy);
        String mockName = this.toInstanceName(type, mockSettings);
        MockRepository.addAfterMethodRunner((Runnable)new MockitoStateCleanerRunnable());
        Class typeToMock = this.isFinalJavaSystemClass(type) ? new ClassReplicaCreator().createClassReplica(type) : type;
        MockData<T> mockData = this.createMethodInvocationControl(mockName, typeToMock, methods, isSpy, delegator, mockSettings);
        Object mock = mockData.getMock();
        if (this.isFinalJavaSystemClass(type) && !isStatic) {
            mock = Whitebox.newInstance((Class)type);
            DefaultFieldValueGenerator.fillWithDefaultValues(mock);
        }
        if (isStatic) {
            MockRepository.putStaticMethodInvocationControl((Class)type, (MethodInvocationControl)mockData.getMethodInvocationControl());
        } else {
            MockRepository.putInstanceMethodInvocationControl(mock, (MethodInvocationControl)mockData.getMethodInvocationControl());
        }
        if (isSpy) {
            new LenientCopyTool().copyToMock(delegator, mock);
        }
        return mock;
    }

    private <T> boolean isFinalJavaSystemClass(Class<T> type) {
        return type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> MockData<T> createMethodInvocationControl(String mockName, Class<T> type, Method[] methods, boolean isSpy, Object delegator, MockSettings mockSettings) {
        MockSettingsImpl settings;
        if (mockSettings == null) {
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(MockCreator.class.getClassLoader());
            try {
                settings = (MockSettingsImpl)Mockito.withSettings();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
        } else {
            settings = (MockSettingsImpl)mockSettings;
        }
        if (isSpy) {
            settings.defaultAnswer(Mockito.CALLS_REAL_METHODS);
        }
        settings.setMockName((MockName)new MockNameImpl(mockName));
        settings.setTypeToMock(type);
        InternalMockHandler mockHandler = new MockHandlerFactory().create((MockCreationSettings)settings);
        PowerMockMethodInterceptorFilter filter = new PowerMockMethodInterceptorFilter(mockHandler, (MockCreationSettings)settings);
        T mock = new ClassImposterizer(new InstantiatorProvider().getInstantiator((MockCreationSettings)settings)).imposterise((MethodInterceptor)filter, type, new Class[0]);
        ClassLoader classLoader = mock.getClass().getClassLoader();
        if (classLoader instanceof MockClassLoader) {
            MockClassLoader mcl = (MockClassLoader)classLoader;
            mcl.cache(mock.getClass());
        }
        MockitoMethodInvocationControl invocationControl = new MockitoMethodInvocationControl((MethodInterceptorFilter)filter, isSpy && delegator == null ? new Object() : delegator, mock, methods);
        return new MockData<T>(invocationControl, mock);
    }

    private String toInstanceName(Class<?> clazz, MockSettings mockSettings) {
        String settingName;
        if (mockSettings instanceof MockSettingsImpl && (settingName = ((MockSettingsImpl)mockSettings).getName()) != null) {
            return settingName;
        }
        String className = clazz.getSimpleName();
        if (className.length() == 0) {
            return clazz.getName();
        }
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    private class MockitoStateCleanerRunnable
    implements Runnable {
        private MockitoStateCleanerRunnable() {
        }

        @Override
        public void run() {
            MockitoStateCleaner cleaner = new MockitoStateCleaner();
            cleaner.clearConfiguration();
            cleaner.clearMockProgress();
        }
    }

    private class MockData<T> {
        private final MockitoMethodInvocationControl methodInvocationControl;
        private final T mock;

        MockData(MockitoMethodInvocationControl methodInvocationControl, T mock) {
            this.methodInvocationControl = methodInvocationControl;
            this.mock = mock;
        }

        public MockitoMethodInvocationControl getMethodInvocationControl() {
            return this.methodInvocationControl;
        }

        public T getMock() {
            return this.mock;
        }
    }
}

