/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariTechPreviewDriverService
extends DriverService {
    public static final String TP_SAFARI_DRIVER_NAME = "safaridriver";
    public static final String TP_SAFARI_DRIVER_EXE_PROPERTY = "webdriver.tp.safari.driver";
    private static final File TP_SAFARI_DRIVER_EXECUTABLE = new File("/Applications/Safari Technology Preview.app/Contents/MacOS/safaridriver");

    protected Capabilities getDefaultDriverOptions() {
        return new SafariOptions().setUseTechnologyPreview(true);
    }

    public SafariTechPreviewDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    public SafariTechPreviewDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    public String getDriverName() {
        return TP_SAFARI_DRIVER_NAME;
    }

    public String getDriverProperty() {
        return TP_SAFARI_DRIVER_EXE_PROPERTY;
    }

    public File getDriverExecutable() {
        return TP_SAFARI_DRIVER_EXECUTABLE;
    }

    public static SafariTechPreviewDriverService createDefaultService() {
        return (SafariTechPreviewDriverService)new Builder().build();
    }

    static boolean isPresent() {
        return SafariTechPreviewDriverService.findExePath((String)TP_SAFARI_DRIVER_EXECUTABLE.getAbsolutePath(), (String)TP_SAFARI_DRIVER_EXE_PROPERTY) != null;
    }

    protected void waitUntilAvailable() {
        try {
            PortProber.waitForPortUp((int)this.getUrl().getPort(), (int)((int)this.getTimeout().toMillis()), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<SafariTechPreviewDriverService, Builder> {
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.SAFARI_TECH_PREVIEW.browserName().equals(capabilities.getBrowserName())) {
                ++score;
            }
            return score;
        }

        protected List<String> createArgs() {
            return Arrays.asList("--port", String.valueOf(this.getPort()));
        }

        protected SafariTechPreviewDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new SafariTechPreviewDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

