/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.ParameterInfo;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.RequestBodyInfo;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.web.multipart.MultipartFile;

public class GenericParameterBuilder {
    private static final List<Class<?>> FILE_TYPES = new ArrayList();
    private static final List<Class> ANNOTATIOSN_TO_IGNORE = new ArrayList<Class>();
    private final PropertyResolverUtils propertyResolverUtils;

    public GenericParameterBuilder(PropertyResolverUtils propertyResolverUtils) {
        this.propertyResolverUtils = propertyResolverUtils;
    }

    public static void addFileType(Class<?> ... classes) {
        FILE_TYPES.addAll(Arrays.asList(classes));
    }

    public static void addAnnotationsToIgnore(Class<?> ... classes) {
        ANNOTATIOSN_TO_IGNORE.addAll(Arrays.asList(classes));
    }

    public static void removeAnnotationsToIgnore(Class<?> ... classes) {
        List<Class<?>> classesToIgnore = Arrays.asList(classes);
        if (ANNOTATIOSN_TO_IGNORE.containsAll(classesToIgnore)) {
            ANNOTATIOSN_TO_IGNORE.removeAll(Arrays.asList(classes));
        }
    }

    io.swagger.v3.oas.models.parameters.Parameter mergeParameter(List<io.swagger.v3.oas.models.parameters.Parameter> existingParamDoc, io.swagger.v3.oas.models.parameters.Parameter paramCalcul) {
        io.swagger.v3.oas.models.parameters.Parameter result = paramCalcul;
        if (paramCalcul != null && paramCalcul.getName() != null) {
            String name = paramCalcul.getName();
            io.swagger.v3.oas.models.parameters.Parameter paramDoc = existingParamDoc.stream().filter(p -> name.equals(p.getName())).findAny().orElse(null);
            if (paramDoc != null) {
                this.mergeParameter(paramCalcul, paramDoc);
                result = paramDoc;
            } else {
                existingParamDoc.add(result);
            }
        }
        return result;
    }

    private void mergeParameter(io.swagger.v3.oas.models.parameters.Parameter paramCalcul, io.swagger.v3.oas.models.parameters.Parameter paramDoc) {
        if (StringUtils.isBlank((CharSequence)paramDoc.getDescription())) {
            paramDoc.setDescription(paramCalcul.getDescription());
        }
        if (StringUtils.isBlank((CharSequence)paramDoc.getIn())) {
            paramDoc.setIn(paramCalcul.getIn());
        }
        if (paramDoc.getExample() == null) {
            paramDoc.setExample(paramCalcul.getExample());
        }
        if (paramDoc.getDeprecated() == null) {
            paramDoc.setDeprecated(paramCalcul.getDeprecated());
        }
        if (paramDoc.getRequired() == null) {
            paramDoc.setRequired(paramCalcul.getRequired());
        }
        if (paramDoc.getAllowEmptyValue() == null) {
            paramDoc.setAllowEmptyValue(paramCalcul.getAllowEmptyValue());
        }
        if (paramDoc.getAllowReserved() == null) {
            paramDoc.setAllowReserved(paramCalcul.getAllowReserved());
        }
        if (StringUtils.isBlank((CharSequence)paramDoc.get$ref())) {
            paramDoc.set$ref(paramDoc.get$ref());
        }
        if (paramDoc.getSchema() == null) {
            paramDoc.setSchema(paramCalcul.getSchema());
        }
        if (paramDoc.getExamples() == null) {
            paramDoc.setExamples(paramCalcul.getExamples());
        }
        if (paramDoc.getExtensions() == null) {
            paramDoc.setExtensions(paramCalcul.getExtensions());
        }
        if (paramDoc.getStyle() == null) {
            paramDoc.setStyle(paramCalcul.getStyle());
        }
        if (paramDoc.getExplode() == null) {
            paramDoc.setExplode(paramCalcul.getExplode());
        }
    }

    io.swagger.v3.oas.models.parameters.Parameter buildParameterFromDoc(Parameter parameterDoc, Components components, JsonView jsonView) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
            parameter.setDescription(this.propertyResolverUtils.resolve(parameterDoc.description()));
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.name())) {
            parameter.setName(this.propertyResolverUtils.resolve(parameterDoc.name()));
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.in().toString())) {
            parameter.setIn(parameterDoc.in().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.example())) {
            try {
                parameter.setExample((Object)Json.mapper().readTree(parameterDoc.example()));
            }
            catch (IOException e) {
                parameter.setExample((Object)parameterDoc.example());
            }
        }
        if (parameterDoc.deprecated()) {
            parameter.setDeprecated(Boolean.valueOf(parameterDoc.deprecated()));
        }
        if (parameterDoc.required()) {
            parameter.setRequired(Boolean.valueOf(parameterDoc.required()));
        }
        if (parameterDoc.allowEmptyValue()) {
            parameter.setAllowEmptyValue(Boolean.valueOf(parameterDoc.allowEmptyValue()));
        }
        if (parameterDoc.allowReserved()) {
            parameter.setAllowReserved(Boolean.valueOf(parameterDoc.allowReserved()));
        }
        this.setSchema(parameterDoc, components, jsonView, parameter);
        this.setExamples(parameterDoc, parameter);
        this.setExtensions(parameterDoc, parameter);
        this.setParameterStyle(parameter, parameterDoc);
        this.setParameterExplode(parameter, parameterDoc);
        return parameter;
    }

    private void setSchema(Parameter parameterDoc, Components components, JsonView jsonView, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.ref())) {
            parameter.$ref(parameterDoc.ref());
        } else {
            io.swagger.v3.oas.models.media.Schema schema = AnnotationsUtils.getSchemaFromAnnotation((Schema)parameterDoc.schema(), (Components)components, (JsonView)jsonView).orElse(null);
            if (schema == null) {
                if (parameterDoc.content().length > 0) {
                    if (AnnotationsUtils.hasSchemaAnnotation((Schema)parameterDoc.content()[0].schema())) {
                        schema = AnnotationsUtils.getSchemaFromAnnotation((Schema)parameterDoc.content()[0].schema(), (Components)components, (JsonView)jsonView).orElse(null);
                    } else if (AnnotationsUtils.hasArrayAnnotation((ArraySchema)parameterDoc.content()[0].array())) {
                        schema = AnnotationsUtils.getArraySchema((ArraySchema)parameterDoc.content()[0].array(), (Components)components, (JsonView)jsonView).orElse(null);
                    }
                } else {
                    schema = AnnotationsUtils.getArraySchema((ArraySchema)parameterDoc.array(), (Components)components, (JsonView)jsonView).orElse(null);
                }
            }
            parameter.setSchema(schema);
        }
    }

    io.swagger.v3.oas.models.media.Schema calculateSchema(Components components, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo, JsonView jsonView) {
        io.swagger.v3.oas.models.media.Schema schemaN;
        String paramName = parameterInfo.getpName();
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        Class type = methodParameter.getParameterType();
        if (parameterInfo.getParameterModel() == null || parameterInfo.getParameterModel().getSchema() == null) {
            if (this.isFile(type)) {
                io.swagger.v3.oas.models.media.Schema schemaN2 = this.getFileSchema(requestBodyInfo);
                schemaN2.addProperties(paramName, (io.swagger.v3.oas.models.media.Schema)new FileSchema());
                return schemaN2;
            }
            if (methodParameter.getGenericParameterType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)methodParameter.getGenericParameterType();
                if (this.isFile(parameterizedType)) {
                    return this.extractFileSchema(paramName, requestBodyInfo);
                }
                schemaN = SpringDocAnnotationsUtils.extractSchema(components, methodParameter.getGenericParameterType(), jsonView, methodParameter.getParameterAnnotations());
            } else {
                schemaN = SpringDocAnnotationsUtils.resolveSchemaFromType(methodParameter.getParameterType(), components, jsonView, methodParameter.getParameterAnnotations());
            }
        } else {
            schemaN = parameterInfo.getParameterModel().getSchema();
        }
        if (requestBodyInfo != null) {
            if (requestBodyInfo.getMergedSchema() != null) {
                requestBodyInfo.getMergedSchema().addProperties(paramName, schemaN);
                schemaN = requestBodyInfo.getMergedSchema();
            } else {
                requestBodyInfo.addProperties(paramName, schemaN);
            }
        }
        return schemaN;
    }

    public boolean isFile(MethodParameter methodParameter) {
        if (methodParameter.getGenericParameterType() instanceof ParameterizedType) {
            Type type = methodParameter.getGenericParameterType();
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.isFile(parameterizedType);
        }
        Class type = methodParameter.getParameterType();
        return this.isFile(type);
    }

    public boolean isAnnotationToIgnore(MethodParameter parameter) {
        return ANNOTATIOSN_TO_IGNORE.stream().anyMatch(annotation -> parameter.getParameterAnnotation(annotation) != null || AnnotationUtils.findAnnotation((Class)parameter.getParameterType(), (Class)annotation) != null);
    }

    private io.swagger.v3.oas.models.media.Schema extractFileSchema(String paramName, RequestBodyInfo requestBodyInfo) {
        io.swagger.v3.oas.models.media.Schema schemaN = this.getFileSchema(requestBodyInfo);
        io.swagger.v3.oas.models.media.ArraySchema schemaFile = new io.swagger.v3.oas.models.media.ArraySchema();
        schemaFile.items((io.swagger.v3.oas.models.media.Schema)new FileSchema());
        schemaN.addProperties(paramName, (io.swagger.v3.oas.models.media.Schema)new io.swagger.v3.oas.models.media.ArraySchema().items((io.swagger.v3.oas.models.media.Schema)new FileSchema()));
        return schemaN;
    }

    private io.swagger.v3.oas.models.media.Schema getFileSchema(RequestBodyInfo requestBodyInfo) {
        io.swagger.v3.oas.models.media.Schema schemaN;
        if (requestBodyInfo.getMergedSchema() != null) {
            schemaN = requestBodyInfo.getMergedSchema();
        } else {
            schemaN = new ObjectSchema();
            requestBodyInfo.setMergedSchema(schemaN);
        }
        return schemaN;
    }

    private boolean isFile(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getActualTypeArguments()[0];
        if (MultipartFile.class.getName().equals(type.getTypeName()) || FilePart.class.getName().equals(type.getTypeName())) {
            return true;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = wildcardType.getUpperBounds();
            return MultipartFile.class.getName().equals(upperBounds[0].getTypeName());
        }
        return false;
    }

    private void setExamples(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        HashMap exampleMap = new HashMap();
        if (parameterDoc.examples().length == 1 && StringUtils.isBlank((CharSequence)parameterDoc.examples()[0].name())) {
            Optional exampleOptional = AnnotationsUtils.getExample((ExampleObject)parameterDoc.examples()[0]);
            exampleOptional.ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setExample(arg_0));
        } else {
            for (ExampleObject exampleObject : parameterDoc.examples()) {
                AnnotationsUtils.getExample((ExampleObject)exampleObject).ifPresent(example -> exampleMap.put(exampleObject.name(), example));
            }
        }
        if (exampleMap.size() > 0) {
            parameter.setExamples(exampleMap);
        }
    }

    private void setExtensions(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (parameterDoc.extensions().length > 0) {
            Map extensionMap = AnnotationsUtils.getExtensions((Extension[])parameterDoc.extensions());
            extensionMap.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).addExtension(arg_0, arg_1));
        }
    }

    private void setParameterExplode(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (this.isExplodable(p)) {
            if (Explode.TRUE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.TRUE);
            } else if (Explode.FALSE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.FALSE);
            }
        }
    }

    private void setParameterStyle(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (StringUtils.isNotBlank((CharSequence)p.style().toString())) {
            parameter.setStyle(Parameter.StyleEnum.valueOf((String)p.style().toString().toUpperCase()));
        }
    }

    private boolean isExplodable(Parameter p) {
        Schema schema = p.schema();
        boolean explode = true;
        Class implementation = schema.implementation();
        if (implementation == Void.class && !schema.type().equals("object") && !schema.type().equals("array")) {
            explode = false;
        }
        return explode;
    }

    private boolean isFile(Class type) {
        return FILE_TYPES.stream().anyMatch(clazz -> clazz.isAssignableFrom(type));
    }

    static {
        FILE_TYPES.add(MultipartFile.class);
        ANNOTATIOSN_TO_IGNORE.add(Hidden.class);
    }
}

