/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractSwaggerWelcome
implements InitializingBean {
    protected final SwaggerUiConfigProperties swaggerUiConfig;
    protected final SpringDocConfigProperties springDocConfigProperties;
    protected String uiRootPath;
    @Value(value="${springdoc.swagger-ui.oauth2RedirectUrl:#{null}}")
    protected String oauth2RedirectUrl;
    @Value(value="${springdoc.swagger-ui.configUrl:#{null}}")
    private String originConfigUrl;
    @Value(value="${springdoc.swagger-ui.url:#{null}}")
    private String swaggerUiUrl;

    public AbstractSwaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.springDocConfigProperties = springDocConfigProperties;
    }

    public void afterPropertiesSet() {
        this.springDocConfigProperties.getGroupConfigs().forEach(groupConfig -> this.swaggerUiConfig.addGroup(groupConfig.getGroup()));
        this.calculateUiRootPath(new StringBuilder[0]);
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1) + docsUrl;
        }
        return contextPath + docsUrl;
    }

    protected void buildConfigUrl(String contextPath, UriComponentsBuilder uriComponentsBuilder) {
        String apiDocsUrl = this.springDocConfigProperties.getApiDocs().getPath();
        if (StringUtils.isEmpty((CharSequence)this.originConfigUrl)) {
            String url = this.buildUrl(contextPath, apiDocsUrl);
            String swaggerConfigUrl = url + "/" + "swagger-config";
            this.swaggerUiConfig.setConfigUrl(swaggerConfigUrl);
            if (this.swaggerUiConfig.getUrls().isEmpty()) {
                if (StringUtils.isEmpty((CharSequence)this.swaggerUiUrl)) {
                    this.swaggerUiConfig.setUrl(url);
                } else {
                    this.swaggerUiConfig.setUrl(this.swaggerUiUrl);
                }
            } else {
                this.swaggerUiConfig.addUrl(url);
            }
        }
        this.calculateOauth2RedirectUrl(uriComponentsBuilder);
    }

    protected UriComponentsBuilder getUriComponentsBuilder(String sbUrl) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)sbUrl);
        uriBuilder.queryParam("configUrl", new Object[]{this.swaggerUiConfig.getConfigUrl()});
        if (StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfig.getLayout())) {
            uriBuilder.queryParam("layout", new Object[]{this.swaggerUiConfig.getLayout()});
        }
        if (StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfig.getFilter())) {
            uriBuilder.queryParam("filter", new Object[]{this.swaggerUiConfig.getFilter()});
        }
        return uriBuilder;
    }

    protected abstract void calculateOauth2RedirectUrl(UriComponentsBuilder var1);

    protected abstract void calculateUiRootPath(StringBuilder ... var1);
}

